/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.math;

import malte0811.controlengineering.util.math.Vec2d;

public record RectangleD(double minX, double minY, double maxX, double maxY) {
    public RectangleD(Vec2d min, Vec2d max) {
        this(min.x(), min.y(), max.x(), max.y());
    }

    public boolean contains(RectangleD other) {
        return this.containsClosed(other.minX, other.minY) && this.containsClosed(other.maxX, other.maxY);
    }

    public boolean containsClosed(double x, double y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public boolean disjoint(RectangleD other) {
        return this.minX >= other.maxX || other.minX >= this.maxX || this.minY >= other.maxY || other.minY >= this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }
}

