/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.math;

import javax.annotation.Nullable;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.math.Vec2i;

public record RectangleI(int minX, int minY, int maxX, int maxY) {
    public RectangleI(Vec2i min, Vec2i max) {
        this(min.x(), min.y(), max.x(), max.y());
    }

    public boolean contains(RectangleI other) {
        return this.containsClosed(other.minX, other.minY) && this.containsClosed(other.maxX, other.maxY);
    }

    public boolean containsClosed(Vec2i point) {
        return this.containsClosed(point.x(), point.y());
    }

    public boolean containsClosed(Vec2d point) {
        return this.containsClosed(point.x(), point.y());
    }

    public boolean containsClosed(double x, double y) {
        return (double)this.minX <= x && x <= (double)this.maxX && (double)this.minY <= y && y <= (double)this.maxY;
    }

    public boolean disjoint(RectangleI other) {
        return this.minX >= other.maxX || other.minX >= this.maxX || this.minY >= other.maxY || other.minY >= this.maxY;
    }

    public RectangleI union(@Nullable RectangleI other) {
        if (other == null) {
            return this;
        }
        return new RectangleI(Math.min(this.minX(), other.minX()), Math.min(this.minY(), other.minY()), Math.max(this.maxX(), other.maxX()), Math.max(this.maxY(), other.maxY()));
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public Vec2d center() {
        return new Vec2d((double)this.minX() + (double)this.getWidth() / 2.0, (double)this.minY() + (double)this.getHeight() / 2.0);
    }

    public RectangleI offset(Vec2i by) {
        return new RectangleI(this.minX() + by.x(), this.minY() + by.y(), this.maxX() + by.x(), this.maxY + by.y());
    }
}

