/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.math;

import malte0811.controlengineering.util.math.Vec2i;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec2;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public record Vec2d(double x, double y) {
    public static final MyCodec<Vec2d> CODEC = new RecordCodec2<Vec2d, Double, Double>(new CodecField<Vec2d, Double>("x", Vec2d::x, MyCodecs.DOUBLE), new CodecField<Vec2d, Double>("y", Vec2d::y, MyCodecs.DOUBLE), Vec2d::new);
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);

    public Vec2d(FriendlyByteBuf in) {
        this(in.readDouble(), in.readDouble());
    }

    public void write(FriendlyByteBuf out) {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    public static Vec2d lerp(Vec2d start, Vec2d end, double time) {
        return new Vec2d(Mth.m_14139_((double)time, (double)start.x, (double)end.x), Mth.m_14139_((double)time, (double)start.y, (double)end.y));
    }

    public Vec2d scale(double scale) {
        return new Vec2d(this.x * scale, this.y * scale);
    }

    public Vec2d subtract(Vec2d rhs) {
        return this.subtract(rhs.x(), rhs.y());
    }

    public Vec2d subtract(double x, double y) {
        return new Vec2d(this.x - x, this.y - y);
    }

    public Vec2d add(Vec2d rhs) {
        return this.add(rhs.x(), rhs.y());
    }

    public Vec2d add(double x, double y) {
        return new Vec2d(this.x + x, this.y + y);
    }

    public Vec2d add(Vec2i size) {
        return new Vec2d(this.x + (double)size.x(), this.y + (double)size.y());
    }

    public double get(int coord) {
        return coord == 1 ? this.y : this.x;
    }

    public Vec2i floor() {
        return new Vec2i(Mth.m_14107_((double)this.x), Mth.m_14107_((double)this.y));
    }

    public Vec3 withHeight(double height) {
        return new Vec3(this.x(), height, this.y());
    }
}

