/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec;

import java.util.function.Function;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeManager;
import malte0811.controlengineering.util.mycodec.tree.TreeStorage;

public record DispatchCodec<Type, Instance>(MyCodec<Type> typeCodec, Function<? super Instance, ? extends Type> type, Function<? super Type, ? extends MyCodec<? extends Instance>> codec) implements MyCodec<Instance>
{
    @Override
    public <B> TreeElement<B> toTree(Instance in, TreeManager<B> manager) {
        TreeStorage<B> result = manager.makeTree();
        Type type = this.type().apply(in);
        result.put("type", this.typeCodec.toTree(type, manager));
        MyCodec<Instance> instanceCodec = this.codec().apply(type);
        result.put("data", this.toNBT(instanceCodec, in, manager));
        return result;
    }

    private <I extends Instance, B> TreeElement<B> toNBT(MyCodec<I> codec, Instance inst, TreeManager<B> manager) {
        return codec.toTree(inst, manager);
    }

    @Override
    @Nullable
    public Instance fromTree(TreeElement<?> data) {
        if (!(data instanceof TreeStorage)) {
            return null;
        }
        TreeStorage tree = (TreeStorage)data;
        Type type = this.typeCodec.fromTree(tree.get("type"));
        MyCodec<Instance> instanceCodec = this.codec.apply(type);
        return instanceCodec.fromTree(tree.get("data"));
    }

    @Override
    public void toSerial(SerialStorage out, Instance in) {
        Type type = this.type().apply(in);
        this.typeCodec.toSerial(out, type);
        MyCodec<Instance> instanceCodec = this.codec().apply(type);
        this.toSerial(out, instanceCodec, in);
    }

    private <I extends Instance> void toSerial(SerialStorage out, MyCodec<I> codec, Instance inst) {
        codec.toSerial(out, inst);
    }

    @Override
    public FastDataResult<Instance> fromSerial(SerialStorage in) {
        FastDataResult<Type> maybeType = this.typeCodec.fromSerial(in);
        if (maybeType.isError()) {
            return maybeType.propagateError();
        }
        MyCodec<Instance> instanceCodec = this.codec.apply(maybeType.get());
        return instanceCodec.fromSerial(in).map(i -> i);
    }
}

