/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeManager;
import malte0811.controlengineering.util.mycodec.tree.TreeStorageList;

public record ListCodec<T>(MyCodec<T> inner) implements MyCodec<List<T>>
{
    @Override
    public <B> TreeElement<B> toTree(List<T> in, TreeManager<B> manager) {
        TreeStorageList<B> result = manager.makeList();
        for (T element : in) {
            result.add(this.inner.toTree(element, manager));
        }
        return result;
    }

    @Override
    @Nullable
    public List<T> fromTree(TreeElement<?> data) {
        if (!(data instanceof TreeStorageList)) {
            return null;
        }
        TreeStorageList list = (TreeStorageList)data;
        ArrayList<T> result = new ArrayList<T>();
        for (TreeElement node : list) {
            T element = this.inner.fromTree(node);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public void toSerial(SerialStorage out, List<T> in) {
        out.writeInt(in.size());
        for (T element : in) {
            this.inner.toSerial(out, element);
        }
    }

    @Override
    public FastDataResult<List<T>> fromSerial(SerialStorage in) {
        FastDataResult<Integer> maybeLength = in.readInt();
        if (maybeLength.isError()) {
            return maybeLength.propagateError();
        }
        int length = maybeLength.get();
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            FastDataResult<T> maybeNext = this.inner.fromSerial(in);
            if (maybeNext.isError()) continue;
            result.add(maybeNext.get());
        }
        return FastDataResult.success(result);
    }
}

