/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.DispatchCodec;
import malte0811.controlengineering.util.mycodec.SimpleCodec;
import malte0811.controlengineering.util.mycodec.serial.PacketBufferStorage;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeManager;
import malte0811.controlengineering.util.mycodec.tree.nbt.NBTManager;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public interface MyCodec<T> {
    public <B> TreeElement<B> toTree(T var1, TreeManager<B> var2);

    @Nullable
    public T fromTree(TreeElement<?> var1);

    public void toSerial(SerialStorage var1, T var2);

    public FastDataResult<T> fromSerial(SerialStorage var1);

    default public <T2> MyCodec<T2> xmap(Function<T, T2> to, final Function<T2, T> from) {
        return new SimpleCodec<TreeElement, T2>(TreeElement.class, t -> {
            T original = this.fromTree((TreeElement<?>)t);
            return original != null ? to.apply(original) : null;
        }, (s, t2) -> this.toSerial((SerialStorage)s, (T)from.apply(t2)), s -> this.fromSerial((SerialStorage)s).map(to)){

            @Override
            public <B> TreeElement<B> toTree(T2 in, TreeManager<B> manager) {
                return MyCodec.this.toTree(from.apply(in), manager);
            }
        };
    }

    default public <T2> MyCodec<T2> flatXmap(Function<T, FastDataResult<T2>> to, final Function<T2, T> from) {
        return new SimpleCodec<TreeElement, T2>(TreeElement.class, t -> ((FastDataResult)to.apply(this.fromTree((TreeElement<?>)t))).orElse(null), (s, t2) -> this.toSerial((SerialStorage)s, (T)from.apply(t2)), s -> this.fromSerial((SerialStorage)s).flatMap(to)){

            @Override
            public <B> TreeElement<B> toTree(T2 in, TreeManager<B> manager) {
                return MyCodec.this.toTree(from.apply(in), manager);
            }
        };
    }

    default public T fromNBT(Tag data) {
        return this.fromTree(NBTManager.INSTANCE.of(data));
    }

    default public T fromNBT(Tag data, Supplier<T> fallback) {
        return Objects.requireNonNullElseGet(this.fromNBT(data), fallback);
    }

    default public Tag toNBT(T data) {
        return this.toTree(data, NBTManager.INSTANCE).getDirect();
    }

    default public <E> MyCodec<E> dispatch(Function<? super E, ? extends T> type, Function<? super T, ? extends MyCodec<? extends E>> codec) {
        return new DispatchCodec<T, E>(this, type, codec);
    }

    default public MyCodec<T> copy() {
        return this.xmap(Function.identity(), Function.identity());
    }

    default public T from(FriendlyByteBuf in) {
        return this.fromSerial(new PacketBufferStorage(in)).get();
    }

    default public MyCodec<T> orElse(final MyCodec<T> fallback) {
        return new MyCodec<T>(){

            @Override
            public <B> TreeElement<B> toTree(T in, TreeManager<B> manager) {
                return MyCodec.this.toTree(in, manager);
            }

            @Override
            @Nullable
            public T fromTree(TreeElement<?> data) {
                Object mainResult = MyCodec.this.fromTree(data);
                if (mainResult != null) {
                    return mainResult;
                }
                return fallback.fromTree(data);
            }

            @Override
            public void toSerial(SerialStorage out, T in) {
                MyCodec.this.toSerial(out, in);
            }

            @Override
            public FastDataResult<T> fromSerial(SerialStorage in) {
                in.pushMark();
                FastDataResult result = MyCodec.this.fromSerial(in);
                if (result.isError()) {
                    in.resetToMark();
                    result = fallback.fromSerial(in);
                }
                in.popMark();
                return result;
            }
        };
    }
}

