/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec.record;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodecBase;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeStorage;

public class RecordCodec2<T, E1, E2>
extends RecordCodecBase<T> {
    private final CodecField<T, E1> first;
    private final CodecField<T, E2> second;
    private final BiFunction<E1, E2, T> make;

    public RecordCodec2(CodecField<T, E1> first, CodecField<T, E2> second, BiFunction<E1, E2, T> make) {
        super(first, second);
        this.first = first;
        this.second = second;
        this.make = make;
    }

    @Override
    @Nullable
    public T fromTree(TreeElement<?> data) {
        if (!(data instanceof TreeStorage)) {
            return null;
        }
        TreeStorage tree = (TreeStorage)data;
        E1 firstVal = this.first.fromNBT(tree);
        E2 secondVal = this.second.fromNBT(tree);
        if (firstVal == null || secondVal == null) {
            return null;
        }
        return this.make.apply(firstVal, secondVal);
    }

    @Override
    public FastDataResult<T> fromSerial(SerialStorage in) {
        FastDataResult<E1> maybeFirst = this.first.fromSerial(in);
        if (maybeFirst.isError()) {
            return maybeFirst.propagateError();
        }
        FastDataResult<E2> maybeSecond = this.second.fromSerial(in);
        if (maybeSecond.isError()) {
            return maybeSecond.propagateError();
        }
        return FastDataResult.success(this.make.apply(maybeFirst.get(), maybeSecond.get()));
    }
}

