/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec.record;

import java.util.Arrays;
import java.util.List;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeManager;
import malte0811.controlengineering.util.mycodec.tree.TreeStorage;

public abstract class RecordCodecBase<T>
implements MyCodec<T> {
    private final List<CodecField<T, ?>> fields;

    @SafeVarargs
    protected RecordCodecBase(CodecField<T, ?> ... fields) {
        this.fields = Arrays.asList(fields);
    }

    public List<CodecField<T, ?>> getFields() {
        return this.fields;
    }

    @Override
    public final <B> TreeElement<B> toTree(T in, TreeManager<B> manager) {
        TreeStorage<B> result = manager.makeTree();
        for (CodecField<T, ?> field : this.fields) {
            result.put(field.name(), field.toNBT(in, manager));
        }
        return result;
    }

    @Override
    public final void toSerial(SerialStorage out, T in) {
        for (CodecField<T, ?> field : this.fields) {
            field.toSerial(out, in);
        }
    }
}

