/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec.serial;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.serial.SerialStorage;

public class StringListStorage
implements SerialStorage {
    private final List<String> data;
    private final IntStack marks = new IntArrayList();
    private int nextReadIndex;

    public StringListStorage(List<String> data) {
        this.data = data;
    }

    public StringListStorage() {
        this(new ArrayList<String>());
    }

    @Nonnull
    private FastDataResult<String> poll() {
        if (this.nextReadIndex < this.data.size()) {
            FastDataResult<String> result = FastDataResult.success(this.data.get(this.nextReadIndex));
            ++this.nextReadIndex;
            return result;
        }
        return FastDataResult.error("Not enough data");
    }

    @Override
    public void writeInt(int value, int base) {
        this.data.add(Integer.toString(value, base));
    }

    @Override
    public FastDataResult<Integer> readInt(int base) {
        return this.read(s -> Integer.parseInt(s, base), "base-" + base + " integer");
    }

    @Override
    public void writeString(String value) {
        this.data.add(value);
    }

    @Override
    public FastDataResult<String> readString() {
        return this.poll();
    }

    @Override
    public void writeBoolean(boolean value) {
        this.data.add(Boolean.toString(value));
    }

    @Override
    public FastDataResult<Boolean> readBoolean() {
        return this.read(Boolean::parseBoolean, "boolean");
    }

    @Override
    public FastDataResult<Byte> readByte() {
        return this.read(Byte::parseByte, "byte");
    }

    @Override
    public void writeByte(byte value) {
        this.data.add(Byte.toString(value));
    }

    @Override
    public FastDataResult<Float> readFloat() {
        return this.read(Float::parseFloat, "float");
    }

    @Override
    public void writeFloat(float value) {
        this.data.add(Float.toString(value));
    }

    @Override
    public FastDataResult<Double> readDouble() {
        return this.read(Double::parseDouble, "double");
    }

    @Override
    public void writeDouble(double value) {
        this.data.add(Double.toString(value));
    }

    @Override
    public FastDataResult<Long> readLong() {
        return this.read(Long::parseLong, "long");
    }

    @Override
    public void writeLong(long value) {
        this.data.add(Long.toString(value));
    }

    @Override
    public void pushMark() {
        this.marks.push(this.nextReadIndex);
    }

    @Override
    public void resetToMark() {
        this.nextReadIndex = this.marks.peekInt(0);
    }

    @Override
    public void popMark() {
        this.marks.popInt();
    }

    public List<String> getData() {
        return new ArrayList<String>(this.data);
    }

    private <T> FastDataResult<T> read(Function<String, T> parse, String desc) {
        FastDataResult<String> maybeToken = this.poll();
        if (maybeToken.isError()) {
            return maybeToken.propagateError();
        }
        String token = maybeToken.get();
        try {
            return FastDataResult.success(parse.apply(token));
        }
        catch (Exception x) {
            return FastDataResult.error(token + " is not a valid " + desc);
        }
    }
}

