/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.mycodec.tree.nbt;

import malte0811.controlengineering.util.mycodec.tree.TreeElement;
import malte0811.controlengineering.util.mycodec.tree.TreeManager;
import malte0811.controlengineering.util.mycodec.tree.TreePrimitive;
import malte0811.controlengineering.util.mycodec.tree.TreeStorage;
import malte0811.controlengineering.util.mycodec.tree.TreeStorageList;
import malte0811.controlengineering.util.mycodec.tree.nbt.NBTList;
import malte0811.controlengineering.util.mycodec.tree.nbt.NBTPrimitive;
import malte0811.controlengineering.util.mycodec.tree.nbt.NBTTree;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTManager
implements TreeManager<Tag> {
    public static final TreeManager<Tag> INSTANCE = new NBTManager();

    private NBTManager() {
    }

    @Override
    public TreeStorageList<Tag> makeList() {
        return new NBTList(new ListTag());
    }

    @Override
    public TreeStorage<Tag> makeTree() {
        return new NBTTree(new CompoundTag());
    }

    @Override
    public TreePrimitive<Tag> makeInt(int value) {
        return new NBTPrimitive((Tag)IntTag.m_128679_((int)value));
    }

    @Override
    public TreePrimitive<Tag> makeByte(byte value) {
        return new NBTPrimitive((Tag)ByteTag.m_128266_((byte)value));
    }

    @Override
    public TreePrimitive<Tag> makeFloat(float value) {
        return new NBTPrimitive((Tag)FloatTag.m_128566_((float)value));
    }

    @Override
    public TreePrimitive<Tag> makeDouble(double value) {
        return new NBTPrimitive((Tag)DoubleTag.m_128500_((double)value));
    }

    @Override
    public TreePrimitive<Tag> makeString(String value) {
        return new NBTPrimitive((Tag)StringTag.m_129297_((String)value));
    }

    @Override
    public TreePrimitive<Tag> makeBoolean(boolean value) {
        return new NBTPrimitive((Tag)ByteTag.m_128273_((boolean)value));
    }

    @Override
    public TreeElement<Tag> makeLong(Long value) {
        return new NBTPrimitive((Tag)LongTag.m_128882_((long)value));
    }

    @Override
    public TreeElement<Tag> of(Tag tag) {
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            return new NBTList(list);
        }
        if (tag instanceof CompoundTag) {
            CompoundTag tree = (CompoundTag)tag;
            return new NBTTree(tree);
        }
        return new NBTPrimitive(tag);
    }
}

