/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.typereg;

import malte0811.controlengineering.util.FastDataResult;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.typereg.TypedRegistry;
import malte0811.controlengineering.util.typereg.TypedRegistryEntry;
import net.minecraft.resources.ResourceLocation;

public abstract class TypedInstance<State, Type extends TypedRegistryEntry<State, ?>> {
    private final Type type;
    protected State currentState;

    public TypedInstance(Type type, State currentState) {
        this.type = type;
        this.currentState = currentState;
    }

    public Type getType() {
        return this.type;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    protected static <T extends TypedRegistryEntry<?, ? extends I>, I extends TypedInstance<?, ? extends T>> MyCodec<I> makeCodec(TypedRegistry<T> registry) {
        MyCodec<TypedRegistryEntry> typeCodec = MyCodecs.RESOURCE_LOCATION.flatXmap(rl -> {
            Object value = registry.get((ResourceLocation)rl);
            return value != null ? FastDataResult.success(value) : FastDataResult.error("Unknown key: " + rl);
        }, TypedRegistryEntry::getRegistryName);
        return typeCodec.dispatch(TypedInstance::getType, t -> TypedInstance.instanceCodec(t));
    }

    private static <S, I extends TypedInstance<?, ?>> MyCodec<I> instanceCodec(TypedRegistryEntry<S, ? extends I> type) {
        return type.getStateCodec().xmap(state -> type.newInstance(state), i -> i.getCurrentState());
    }
}

