/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.util.typereg;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.typereg.TypedRegistryEntry;
import net.minecraft.resources.ResourceLocation;

public class TypedRegistry<T extends TypedRegistryEntry<?, ?>> {
    private final Map<ResourceLocation, T> entries = new LinkedHashMap<ResourceLocation, T>();

    public <T2 extends T> T2 register(ResourceLocation name, T2 instance) {
        Preconditions.checkState((!this.entries.containsKey(name) ? 1 : 0) != 0);
        ((TypedRegistryEntry)instance).setRegistryName(name);
        this.entries.put(name, instance);
        return instance;
    }

    @Nullable
    public T get(ResourceLocation name) {
        return (T)((TypedRegistryEntry)this.entries.get(name));
    }

    public Map<ResourceLocation, T> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public Collection<T> getValues() {
        return this.entries.values();
    }
}

