/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.Triple;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockBuilder;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockType;
import com.supermartijn642.rechiseled.api.registration.RechiseledRegistration;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.data.RegistrationBlockStateGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationChiselingRecipeProvider;
import com.supermartijn642.rechiseled.registration.data.RegistrationFusionModelProvider;
import com.supermartijn642.rechiseled.registration.data.RegistrationLanguageGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationLootTableGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationModelGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationTagsGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;

public class RechiseledRegistrationImpl
implements RechiseledRegistration {
    private static final Map<String, RechiseledRegistrationImpl> REGISTRATION_MAP = new HashMap<String, RechiseledRegistrationImpl>();
    private static boolean finalized = false;
    private final String modid;
    private final List<RechiseledBlockBuilderImpl> unfinishedBlockBuilders = new ArrayList<RechiseledBlockBuilderImpl>();
    private final List<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>> blockBuilders = new ArrayList<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>>();
    private final Set<String> usedBlockIdentifiers = new HashSet<String>();
    private final List<RechiseledBlockTypeImpl> blockTypes = new ArrayList<RechiseledBlockTypeImpl>();
    private final List<Triple<ResourceLocation, Supplier<ItemLike>, Supplier<ItemLike>>> chiselingEntries = new ArrayList<Triple<ResourceLocation, Supplier<ItemLike>, Supplier<ItemLike>>>();
    private CreativeItemGroup itemGroup;
    private String itemGroupTranslation;
    public boolean providersRegistered = false;

    public static synchronized RechiseledRegistration get(String modid) {
        if (!RegistryUtil.isValidNamespace((String)modid)) {
            throw new RuntimeException("Invalid modid '" + modid + "'!");
        }
        if (!CommonUtils.isModLoaded((String)modid)) {
            throw new RuntimeException("Could not find any mod for modid '" + modid + "'!");
        }
        return REGISTRATION_MAP.computeIfAbsent(modid, RechiseledRegistrationImpl::new);
    }

    public static void finalizeRegistration() {
        finalized = true;
        REGISTRATION_MAP.values().forEach(registration -> {
            if (!registration.unfinishedBlockBuilders.isEmpty()) {
                if (registration.unfinishedBlockBuilders.size() == 1) {
                    throw new IllegalStateException("Found uncompleted rechiseled block builder '" + registration.modid + ":" + registration.unfinishedBlockBuilders.get(0).getIdentifier() + "'!");
                }
                String builders = registration.unfinishedBlockBuilders.stream().map(b -> "'" + registration.modid + ":" + b.getIdentifier() + "'").collect(Collectors.joining(","));
                throw new IllegalStateException("Found uncompleted rechiseled block builders " + builders + "!");
            }
        });
    }

    private RechiseledRegistrationImpl(String modid) {
        this.modid = modid;
    }

    @Override
    public synchronized RechiseledBlockBuilder block(String identifier) {
        if (finalized) {
            throw new RuntimeException("Blocks must be built during mod initialization!");
        }
        if (!this.usedBlockIdentifiers.add(identifier)) {
            throw new RuntimeException("Duplicate block builder request from '" + this.modid + "' for identifier '" + identifier + "'!");
        }
        RechiseledBlockBuilderImpl builder = new RechiseledBlockBuilderImpl(this, identifier);
        this.unfinishedBlockBuilders.add(builder);
        return builder;
    }

    @Override
    public synchronized void chiselingEntry(ResourceLocation recipe, Supplier<ItemLike> regularItem, Supplier<ItemLike> connectingItem) {
        if (finalized) {
            throw new RuntimeException("Chiseling recipe entries must be added during mod initialization!");
        }
        if (regularItem == null && connectingItem == null) {
            throw new IllegalArgumentException("Either regular item or connecting item must not be null!");
        }
        this.chiselingEntries.add((Triple<ResourceLocation, Supplier<ItemLike>, Supplier<ItemLike>>)Triple.of((Object)recipe, regularItem, connectingItem));
    }

    public CreativeItemGroup itemGroup(Supplier<ItemLike> icon, String translation) {
        if (finalized) {
            throw new RuntimeException("Chiseling recipe entries must be added during mod initialization!");
        }
        if (this.itemGroup != null) {
            throw new IllegalStateException("An item group for '" + this.modid + "' registration has already been created!");
        }
        this.itemGroup = CreativeItemGroup.create((String)this.modid, () -> ((ItemLike)icon.get()).m_5456_());
        this.itemGroup.filler(stackConsumer -> {
            LinkedList<BlockItem> items = new LinkedList<BlockItem>();
            for (RechiseledBlockType type : this.getAllBlockTypes()) {
                items.add(type.getRegularItem());
                items.add(type.getConnectingItem());
            }
            items.stream().filter(Objects::nonNull).map(ItemStack::new).forEach((Consumer<ItemStack>)stackConsumer);
        });
        this.itemGroupTranslation = translation;
        return this.itemGroup;
    }

    @Override
    public Collection<RechiseledBlockType> getAllBlockTypes() {
        return Collections.unmodifiableCollection(this.blockTypes);
    }

    @Override
    public void registerDataProviders() {
        if (this.providersRegistered) {
            throw new RuntimeException("Data providers have already been registered!");
        }
        this.providersRegistered = true;
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)this.modid);
        handler.addProvider(generator -> new RegistrationFusionModelProvider(this, (DataGenerator)generator));
        handler.addGenerator(cache -> new RegistrationModelGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationBlockStateGenerator(this, (ResourceCache)cache));
        handler.addProvider((generator, existingFileHelper) -> new RegistrationChiselingRecipeProvider(this, (DataGenerator)generator, (ExistingFileHelper)existingFileHelper));
        handler.addGenerator(cache -> new RegistrationLanguageGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationLootTableGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationTagsGenerator(this, (ResourceCache)cache));
    }

    public String getModid() {
        return this.modid;
    }

    public void finalizeBuilder(RechiseledBlockBuilderImpl builder, RechiseledBlockTypeImpl blockType) {
        this.unfinishedBlockBuilders.remove(builder);
        this.blockBuilders.add((Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>)Pair.of((Object)builder, (Object)blockType));
        this.blockTypes.add(blockType);
    }

    public List<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>> getBlockBuilders() {
        return this.blockBuilders;
    }

    public List<Triple<ResourceLocation, Supplier<ItemLike>, Supplier<ItemLike>>> getChiselingEntries() {
        return this.chiselingEntries;
    }

    public CreativeItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public String getItemGroupTranslation() {
        return this.itemGroupTranslation;
    }
}

