/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.config;

import gisellevonbingen.mmp.common.config.ClientConfig;
import gisellevonbingen.mmp.common.config.CommonConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class MoreMekanismProcessingConfigs {
    public static final Map<ModConfig.Type, ForgeConfigSpec> SPECS = new HashMap<ModConfig.Type, ForgeConfigSpec>();
    public static final CommonConfig Common;
    public static final ForgeConfigSpec CommonSpec;
    public static final ClientConfig Client;
    public static final ForgeConfigSpec ClientSpec;

    public static void register(ModLoadingContext modLoadingContext) {
        MoreMekanismProcessingConfigs.register(modLoadingContext, ModConfig.Type.COMMON);
        Dist dist = FMLEnvironment.dist;
        if (dist.isClient()) {
            MoreMekanismProcessingConfigs.register(modLoadingContext, ModConfig.Type.CLIENT);
        }
        if (dist.isDedicatedServer()) {
            MoreMekanismProcessingConfigs.register(modLoadingContext, ModConfig.Type.SERVER);
        }
    }

    public static void register(ModLoadingContext modLoadingContext, ModConfig.Type type) {
        ForgeConfigSpec spec = SPECS.get(type);
        if (spec != null) {
            modLoadingContext.registerConfig(type, (IConfigSpec)spec);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        MoreMekanismProcessingConfigs.parseConfig((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        MoreMekanismProcessingConfigs.parseConfig((ModConfigEvent)event);
    }

    public static void parseConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ClientSpec) {
            Client.parseConfig();
        }
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        Common = (CommonConfig)common.getLeft();
        CommonSpec = (ForgeConfigSpec)common.getRight();
        SPECS.put(ModConfig.Type.COMMON, CommonSpec);
        Pair client = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        Client = (ClientConfig)client.getLeft();
        ClientSpec = (ForgeConfigSpec)client.getRight();
        SPECS.put(ModConfig.Type.CLIENT, ClientSpec);
    }
}

