/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.google.gson.JsonObject;
import gisellevonbingen.mmp.common.crafting.SingleOutputRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CookingRecipeBuilder
extends SingleOutputRecipeBuilder {
    private Ingredient ingredient;
    private float experience;
    private int smeltingTime;
    private int blastingTime;

    public CookingRecipeBuilder(ResourceLocation id) {
        super(id);
        this.setCookingTime(200);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public float getExperience() {
        return this.experience;
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public int getSmeltingTime() {
        return this.smeltingTime;
    }

    public CookingRecipeBuilder setSmeltingTime(int smeltingTime) {
        this.smeltingTime = smeltingTime;
        return this;
    }

    public int getBlastingTime() {
        return this.blastingTime;
    }

    public CookingRecipeBuilder setBlastingTime(int blastingTime) {
        this.blastingTime = blastingTime;
        return this;
    }

    public CookingRecipeBuilder setCookingTime(int cookingTime) {
        this.setSmeltingTime(cookingTime);
        this.setBlastingTime(cookingTime / 2);
        return this;
    }

    public Result getSmelting() {
        return new Result(this, "smelting", this.smeltingTime, (RecipeSerializer<?>)RecipeSerializer.f_44091_);
    }

    public Result getBlasting() {
        return new Result(this, "blasting", this.blastingTime, (RecipeSerializer<?>)RecipeSerializer.f_44092_);
    }

    public static class Result
    extends SingleOutputRecipeBuilder.SingleOutputRecipeResult {
        private final Ingredient ingredient;
        private final float experience;
        private final int cookingTime;
        private RecipeSerializer<?> type;

        public Result(CookingRecipeBuilder builder, String name, int cookingTime, RecipeSerializer<?> type) {
            super(builder, new ResourceLocation(builder.getId().m_135827_(), builder.getId().m_135815_() + "_" + name));
            this.ingredient = builder.ingredient;
            this.experience = builder.experience;
            this.cookingTime = cookingTime;
            this.type = type;
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookingTime() {
            return this.cookingTime;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }
    }
}

