/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.slurry;

import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import gisellevonbingen.mmp.common.slurry.SlurryDeferredRegister2;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import mekanism.common.registration.impl.SlurryRegistryObject;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;

public class MoreMekanismProcessingSlurries {
    public static final SlurryDeferredRegister2 SLURRIES = new SlurryDeferredRegister2("moremekanismprocessing");
    public static final Map<MaterialType, SlurryRegistryObject<Slurry, Slurry>> MAP = new HashMap<MaterialType, SlurryRegistryObject<Slurry, Slurry>>();

    public static SlurryRegistryObject<Slurry, Slurry> getSlurryRegistry(MaterialType materialType) {
        return MAP.get((Object)materialType);
    }

    public static void register(IEventBus eventBus) {
        MoreMekanismProcessingSlurries.register(eventBus, SLURRIES);
    }

    public static void register(IEventBus eventBus, SlurryDeferredRegister2 register) {
        register.register(eventBus);
        for (MaterialType materialType : MaterialType.values()) {
            MaterialState crystal = MaterialState.CRYSTAL;
            if (!materialType.getResultShape().canProcess(crystal)) continue;
            SlurryRegistryObject<Slurry, Slurry> registryObject = register.register(materialType, (UnaryOperator<SlurryBuilder>)new SlurryBuildOperator(materialType));
            MAP.put(materialType, registryObject);
        }
    }

    public static final class SlurryBuildOperator
    implements UnaryOperator<SlurryBuilder> {
        private final MaterialType materialType;

        private SlurryBuildOperator(MaterialType materialType) {
            this.materialType = materialType;
        }

        @Override
        public SlurryBuilder apply(SlurryBuilder builder) {
            TagKey<Item> tag = MaterialState.ORE.getStateItemTag(this.materialType);
            return builder.ore(tag);
        }

        public MaterialType getOreType() {
            return this.materialType;
        }
    }
}

