/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.slurry;

import gisellevonbingen.mmp.common.item.MoreMekanismProcessingItems;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import gisellevonbingen.mmp.common.slurry.MoreMekanismProcessingSlurryBuilder;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import net.minecraft.network.chat.Component;

public class MoreMekanismProcessingSlurry
extends Slurry {
    public static final String SLURRY = "slurry";
    private final MaterialType materialType;
    private final String slurryType;

    public MoreMekanismProcessingSlurry(MoreMekanismProcessingSlurryBuilder builder) {
        super((SlurryBuilder)builder);
        this.materialType = builder.materialType();
        this.slurryType = builder.slurryType();
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public String getSlurryType() {
        return this.slurryType;
    }

    public int getTint() {
        return this.getMaterialType().getColor();
    }

    public Component getTextComponent() {
        String descriptionId = this.getTranslationKey();
        String statedDescriptionId = this.getStatedDescriptionId();
        return MaterialState.createTextComponent(descriptionId, statedDescriptionId, this.getMaterialType());
    }

    public String getSlurryName() {
        return MoreMekanismProcessingSlurry.getSlurryName(this.getSlurryType(), this.getMaterialType());
    }

    public String getStatedDescriptionId() {
        return MoreMekanismProcessingSlurry.makeDescriptionId(this.getSlurryType());
    }

    public boolean isHidden() {
        MaterialState crystal = MaterialState.CRYSTAL;
        if (!MoreMekanismProcessingItems.testProcessingLevel(this.materialType, crystal)) {
            return true;
        }
        return super.isHidden();
    }

    public static String makeDescriptionId(String slurryType) {
        return MaterialState.makeDescriptionId(MoreMekanismProcessingSlurry.getSlurryTypeKey(slurryType));
    }

    public static String getSlurryTypeKey(String slurryType) {
        return slurryType + "_slurry";
    }

    public static String getSlurryName(String slurryType, MaterialType materialType) {
        return MoreMekanismProcessingSlurry.getSlurryName(slurryType, materialType.getBaseName());
    }

    public static String getSlurryName(String slurryType, String materialType) {
        return slurryType + "_" + materialType;
    }
}

