/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.datagen;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.networking.EnergyCellBlock;
import appeng.init.client.InitItemModelsProperties;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGABlocks;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class MEGABlockModelProvider
extends BlockStateProvider {
    public MEGABlockModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "megacells", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.energyCell();
        this.craftingModel(MEGABlocks.MEGA_CRAFTING_UNIT, "unit");
        this.craftingModel(MEGABlocks.CRAFTING_STORAGE_1M, "1m_storage");
        this.craftingModel(MEGABlocks.CRAFTING_STORAGE_4M, "4m_storage");
        this.craftingModel(MEGABlocks.CRAFTING_STORAGE_16M, "16m_storage");
        this.craftingModel(MEGABlocks.CRAFTING_STORAGE_64M, "64m_storage");
        this.craftingModel(MEGABlocks.CRAFTING_STORAGE_256M, "256m_storage");
        this.craftingModel(MEGABlocks.CRAFTING_ACCELERATOR, "accelerator");
        this.builtInBlockModel("crafting/monitor_formed");
    }

    private void builtInBlockModel(String name) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder("block/" + name);
        ResourceLocation loaderId = MEGACells.makeId("block/" + name);
        model.customLoader((bmb, efh) -> new CustomLoaderBuilder<BlockModelBuilder>(loaderId, bmb, efh){});
    }

    private void craftingModel(MEGABlocks.BlockDefinition<?> block, String name) {
        this.builtInBlockModel("crafting/" + name + "_formed");
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + name, MEGACells.makeId("block/crafting/" + name));
        this.getVariantBuilder((Block)block.asBlock()).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)blockModel)}).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getBuilder("block/crafting/" + name + "_formed"))});
        this.simpleBlockItem((Block)block.asBlock(), (ModelFile)blockModel);
    }

    private void energyCell() {
        VariantBlockStateBuilder blockBuilder = this.getVariantBuilder((Block)MEGABlocks.MEGA_ENERGY_CELL.asBlock());
        ArrayList<BlockModelBuilder> models = new ArrayList<BlockModelBuilder>();
        for (int i = 0; i < 5; ++i) {
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll("block/mega_energy_cell_" + i, MEGACells.makeId("block/mega_energy_cell_" + i));
            blockBuilder.partialState().with((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            models.add(model);
        }
        ItemModelBuilder item = (ItemModelBuilder)this.itemModels().withExistingParent("item/mega_energy_cell", ((ModelFile)models.get(0)).getLocation());
        for (int i = 1; i < models.size(); ++i) {
            float fillFactor = (float)(i - 1) / (float)(models.size() - 1);
            item.override().predicate(InitItemModelsProperties.ENERGY_FILL_LEVEL_ID, fillFactor).model((ModelFile)models.get(i));
        }
    }
}

