/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.datagen;

import appeng.api.util.AEColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.datagen.providers.tags.ConventionTags;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGABlocks;
import gripe._90.megacells.integration.appmek.AppMekCellType;
import gripe._90.megacells.item.MEGAItems;
import gripe._90.megacells.item.MEGAPortableCell;
import gripe._90.megacells.item.MEGAStorageCell;
import gripe._90.megacells.item.core.IMEGACellType;
import gripe._90.megacells.item.core.MEGACellType;
import gripe._90.megacells.item.core.MEGATier;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class MEGARecipeProvider
extends RecipeProvider {
    public MEGARecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.component(consumer, MEGATier._1M, (ItemLike)AEItems.SKY_DUST.m_5456_());
        this.component(consumer, MEGATier._4M, (ItemLike)AEItems.ENDER_DUST.m_5456_());
        this.component(consumer, MEGATier._16M, (ItemLike)AEItems.ENDER_DUST.m_5456_());
        this.component(consumer, MEGATier._64M, (ItemLike)AEItems.MATTER_BALL.m_5456_());
        this.component(consumer, MEGATier._256M, (ItemLike)AEItems.MATTER_BALL.m_5456_());
        this.housing(consumer, MEGACellType.ITEM);
        this.housing(consumer, MEGACellType.FLUID);
        this.housing(consumer, AppMekCellType.CHEMICAL);
        for (Item storage : Stream.of(MEGACellType.ITEM.getCells().stream(), MEGACellType.FLUID.getCells().stream(), AppMekCellType.CHEMICAL.getCells().stream()).flatMap(s -> s).toList()) {
            this.cell(consumer, storage);
        }
        for (Item portable : Stream.of(MEGACellType.ITEM.getPortableCells().stream(), MEGACellType.FLUID.getPortableCells().stream(), AppMekCellType.CHEMICAL.getPortableCells().stream()).flatMap(s -> s).toList()) {
            this.portable(consumer, portable);
        }
        ShapedRecipeBuilder.m_126116_(MEGAItems.BULK_ITEM_CELL).m_126130_("aba").m_126130_("bcb").m_126130_("ddd").m_126127_(Character.valueOf('a'), (ItemLike)AEBlocks.QUARTZ_VIBRANT_GLASS).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.SKY_DUST).m_126127_(Character.valueOf('c'), MEGAItems.BULK_CELL_COMPONENT).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42418_).m_142284_("has_bulk_cell_component", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_(MEGAItems.BULK_CELL_COMPONENT)).m_142700_(consumer, MEGACells.makeId("cells/standard/bulk_item_cell"));
        ShapedRecipeBuilder.m_126116_(MEGABlocks.MEGA_ENERGY_CELL).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)AEBlocks.DENSE_ENERGY_CELL).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).m_142284_("has_dense_energy_cell", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)AEBlocks.DENSE_ENERGY_CELL)).m_142284_("has_engineering_processor", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)AEItems.ENGINEERING_PROCESSOR)).m_142700_(consumer, MEGACells.makeId("mega_energy_cell"));
        ShapedRecipeBuilder.m_126116_(MEGABlocks.MEGA_CRAFTING_UNIT).m_126130_("aba").m_126130_("cdc").m_126130_("aba").m_206416_(Character.valueOf('a'), ConventionTags.IRON_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.LOGIC_PROCESSOR).m_126127_(Character.valueOf('c'), (ItemLike)AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).m_126127_(Character.valueOf('d'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).m_142284_("has_logic_processor", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)AEItems.LOGIC_PROCESSOR)).m_142700_(consumer, MEGACells.makeId("crafting/mega_crafting_unit"));
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_ACCELERATOR, (ItemLike)AEItems.ENGINEERING_PROCESSOR);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_STORAGE_1M, MEGAItems.CELL_COMPONENT_1M);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_STORAGE_4M, MEGAItems.CELL_COMPONENT_4M);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_STORAGE_16M, MEGAItems.CELL_COMPONENT_16M);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_STORAGE_64M, MEGAItems.CELL_COMPONENT_64M);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_STORAGE_256M, MEGAItems.CELL_COMPONENT_256M);
        this.craftingBlock(consumer, MEGABlocks.CRAFTING_MONITOR, (ItemLike)AEParts.STORAGE_MONITOR);
    }

    private void component(Consumer<FinishedRecipe> consumer, MEGATier tier, ItemLike binder) {
        Item preceding = tier == MEGATier._1M ? AEItems.CELL_COMPONENT_256K.m_5456_() : MEGATier.values()[tier.index - 2].getComponent();
        ShapedRecipeBuilder.m_126116_((ItemLike)tier.getComponent()).m_126130_("aba").m_126130_("cdc").m_126130_("aca").m_126127_(Character.valueOf('a'), binder).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.CALCULATION_PROCESSOR).m_126127_(Character.valueOf('c'), (ItemLike)preceding).m_126127_(Character.valueOf('d'), (ItemLike)AEBlocks.QUARTZ_VIBRANT_GLASS).m_142284_("has_" + MEGACells.getItemPath(preceding), (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)preceding)).m_142700_(consumer, MEGACells.makeId(MEGACells.getItemPath(tier.getComponent())));
    }

    private void cell(Consumer<FinishedRecipe> consumer, Item cellItem) {
        MEGAStorageCell cell = (MEGAStorageCell)cellItem;
        Item component = cell.getTier().getComponent();
        Item housing = cell.getType().housing();
        TagKey<Item> housingMaterial = cell.getType().housingMaterial();
        String componentPath = MEGACells.getItemPath(component);
        String cellPath = MEGACells.getItemPath(cellItem);
        ShapedRecipeBuilder.m_126116_((ItemLike)cellItem).m_126130_("aba").m_126130_("bcb").m_126130_("ddd").m_126127_(Character.valueOf('a'), (ItemLike)AEBlocks.QUARTZ_VIBRANT_GLASS).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.SKY_DUST).m_126127_(Character.valueOf('c'), (ItemLike)component).m_206416_(Character.valueOf('d'), housingMaterial).m_142284_("has_" + componentPath, (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)component)).m_142700_(consumer, MEGACells.makeId("cells/standard/" + cellPath));
        ShapelessRecipeBuilder.m_126189_((ItemLike)cellItem).m_126209_((ItemLike)housing).m_126209_((ItemLike)component).m_142284_("has_" + componentPath, (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)component)).m_142284_("has_" + MEGACells.getItemPath(housing), (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)housing)).m_142700_(consumer, MEGACells.makeId("cells/standard/" + cellPath + "_with_housing"));
    }

    private void portable(Consumer<FinishedRecipe> consumer, Item portableCellItem) {
        MEGAPortableCell portableCell = (MEGAPortableCell)portableCellItem;
        Item housing = portableCell.type.housing();
        ShapelessRecipeBuilder.m_126189_((ItemLike)portableCell).m_126209_((ItemLike)AEBlocks.CHEST).m_126209_((ItemLike)portableCell.tier.getComponent()).m_126209_((ItemLike)AEBlocks.ENERGY_CELL).m_126209_((ItemLike)housing).m_142284_("has_" + MEGACells.getItemPath(housing), (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)housing)).m_142284_("has_energy_cell", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)AEBlocks.ENERGY_CELL)).m_142700_(consumer, MEGACells.makeId("cells/portable/" + MEGACells.getItemPath((Item)portableCell)));
    }

    private void housing(Consumer<FinishedRecipe> consumer, IMEGACellType type) {
        Item housing = type.housing();
        ShapedRecipeBuilder.m_126116_((ItemLike)type.housing()).m_126130_("aba").m_126130_("b b").m_126130_("ddd").m_126127_(Character.valueOf('a'), (ItemLike)AEBlocks.QUARTZ_VIBRANT_GLASS).m_126127_(Character.valueOf('b'), (ItemLike)AEItems.SKY_DUST).m_206416_(Character.valueOf('d'), type.housingMaterial()).m_142284_("has_dusts/sky_stone", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_((ItemLike)AEItems.SKY_DUST)).m_142700_(consumer, MEGACells.makeId("cells/" + MEGACells.getItemPath(housing)));
    }

    private void craftingBlock(Consumer<FinishedRecipe> consumer, MEGABlocks.BlockDefinition<?> unit, ItemLike part) {
        ShapelessRecipeBuilder.m_126189_(unit).m_126209_(MEGABlocks.MEGA_CRAFTING_UNIT).m_126209_(part).m_142284_("has_mega_crafting_unit", (CriterionTriggerInstance)MEGARecipeProvider.m_125977_(MEGABlocks.MEGA_CRAFTING_UNIT)).m_142700_(consumer, MEGACells.makeId("crafting/" + MEGACells.getItemPath(unit.m_5456_())));
    }
}

