/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.init.loader;

import gripe._90.megacells.block.MEGABlocks;
import gripe._90.megacells.block.entity.MEGABlockEntities;
import gripe._90.megacells.item.MEGAItems;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registration {
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Registration.initBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registration.initItems((IForgeRegistry<Item>)event.getRegistry());
    }

    public static void registerBlockEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        Registration.initBlockEntities(event.getRegistry());
    }

    public static void initBlocks(IForgeRegistry<Block> registry) {
        for (MEGABlocks.BlockDefinition<?> definition : MEGABlocks.getBlocks()) {
            Object block = definition.asBlock();
            block.setRegistryName(definition.getId());
            registry.register(block);
        }
    }

    public static void initItems(IForgeRegistry<Item> registry) {
        Object item;
        for (MEGABlocks.BlockDefinition<?> blockDefinition : MEGABlocks.getBlocks()) {
            item = (BlockItem)blockDefinition.m_5456_();
            item.setRegistryName(blockDefinition.getId());
            registry.register((IForgeRegistryEntry)item);
        }
        for (MEGAItems.ItemDefinition itemDefinition : MEGAItems.getItems()) {
            item = itemDefinition.m_5456_();
            item.setRegistryName(itemDefinition.getId());
            registry.register((IForgeRegistryEntry)item);
        }
    }

    public static void initBlockEntities(IForgeRegistry<BlockEntityType<?>> registry) {
        for (Map.Entry<ResourceLocation, BlockEntityType<?>> be : MEGABlockEntities.getBlockEntityTypes().entrySet()) {
            registry.register(be.getValue());
        }
    }
}

