/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.init.loader.client;

import appeng.block.AEBaseBlock;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.model.AutoRotatingBakedModel;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import gripe._90.megacells.block.MEGABlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class InitAutoRotatingModel {
    private static final Set<MEGABlocks.BlockDefinition<?>> NO_AUTO_ROTATION = ImmutableSet.of(MEGABlocks.MEGA_CRAFTING_UNIT, MEGABlocks.CRAFTING_ACCELERATOR, MEGABlocks.CRAFTING_STORAGE_1M, MEGABlocks.CRAFTING_STORAGE_4M, MEGABlocks.CRAFTING_STORAGE_16M, MEGABlocks.CRAFTING_STORAGE_64M, (Object[])new MEGABlocks.BlockDefinition[]{MEGABlocks.CRAFTING_STORAGE_256M, MEGABlocks.CRAFTING_MONITOR});
    private static final Map<String, Function<BakedModel, BakedModel>> CUSTOMIZERS = new HashMap<String, Function<BakedModel, BakedModel>>();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(InitAutoRotatingModel::initAutoRotatingModels);
        bus.addListener(InitAutoRotatingModel::onModelBake);
    }

    public static void initAutoRotatingModels(ModelRegistryEvent event) {
        InitAutoRotatingModel.register(MEGABlocks.CRAFTING_MONITOR, InitAutoRotatingModel::customizeCraftingMonitorModel);
        for (MEGABlocks.BlockDefinition<?> block : MEGABlocks.getBlocks()) {
            if (NO_AUTO_ROTATION.contains(block) || !(block.asBlock() instanceof AEBaseBlock)) continue;
            InitAutoRotatingModel.register(block, AutoRotatingBakedModel::new);
        }
    }

    private static void register(MEGABlocks.BlockDefinition<?> block, Function<BakedModel, BakedModel> customizer) {
        String path = block.getId().m_135815_();
        CUSTOMIZERS.put(path, customizer);
    }

    private static BakedModel customizeCraftingMonitorModel(BakedModel model) {
        if (model instanceof MonitorBakedModel) {
            return model;
        }
        return new AutoRotatingBakedModel(model);
    }

    private static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        HashSet keys = Sets.newHashSet(modelRegistry.keySet());
        BakedModel missingModel = (BakedModel)modelRegistry.get(ModelBakery.f_119230_);
        for (ResourceLocation location : keys) {
            BakedModel newModel;
            Function<BakedModel, BakedModel> customizer;
            BakedModel orgModel;
            if (!location.m_135827_().equals("megacells") || (orgModel = (BakedModel)modelRegistry.get(location)) == missingModel || (customizer = CUSTOMIZERS.get(location.m_135815_())) == null || (newModel = customizer.apply(orgModel)) == orgModel) continue;
            modelRegistry.put(location, newModel);
        }
    }
}

