/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item;

import appeng.items.materials.MaterialItem;
import appeng.items.materials.StorageComponentItem;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.item.MEGABulkCell;
import gripe._90.megacells.item.MEGAPortableCell;
import gripe._90.megacells.item.MEGAStorageCell;
import gripe._90.megacells.item.core.IMEGACellType;
import gripe._90.megacells.item.core.MEGACellType;
import gripe._90.megacells.item.core.MEGATier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class MEGAItems {
    public static final List<ItemDefinition<?>> ITEMS = new ArrayList();
    public static final ItemDefinition<MaterialItem> MEGA_ITEM_CELL_HOUSING = MEGAItems.item("mega_item_cell_housing", MaterialItem::new);
    public static final ItemDefinition<MaterialItem> MEGA_FLUID_CELL_HOUSING = MEGAItems.item("mega_fluid_cell_housing", MaterialItem::new);
    public static final ItemDefinition<StorageComponentItem> CELL_COMPONENT_1M = MEGAItems.component(MEGATier._1M);
    public static final ItemDefinition<StorageComponentItem> CELL_COMPONENT_4M = MEGAItems.component(MEGATier._4M);
    public static final ItemDefinition<StorageComponentItem> CELL_COMPONENT_16M = MEGAItems.component(MEGATier._16M);
    public static final ItemDefinition<StorageComponentItem> CELL_COMPONENT_64M = MEGAItems.component(MEGATier._64M);
    public static final ItemDefinition<StorageComponentItem> CELL_COMPONENT_256M = MEGAItems.component(MEGATier._256M);
    public static final ItemDefinition<MEGAStorageCell> ITEM_CELL_1M = MEGAItems.cell(MEGATier._1M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAStorageCell> ITEM_CELL_4M = MEGAItems.cell(MEGATier._4M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAStorageCell> ITEM_CELL_16M = MEGAItems.cell(MEGATier._16M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAStorageCell> ITEM_CELL_64M = MEGAItems.cell(MEGATier._64M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAStorageCell> ITEM_CELL_256M = MEGAItems.cell(MEGATier._256M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAStorageCell> FLUID_CELL_1M = MEGAItems.cell(MEGATier._1M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAStorageCell> FLUID_CELL_4M = MEGAItems.cell(MEGATier._4M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAStorageCell> FLUID_CELL_16M = MEGAItems.cell(MEGATier._16M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAStorageCell> FLUID_CELL_64M = MEGAItems.cell(MEGATier._64M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAStorageCell> FLUID_CELL_256M = MEGAItems.cell(MEGATier._256M, MEGACellType.FLUID);
    public static final ItemDefinition<MaterialItem> BULK_CELL_COMPONENT = MEGAItems.item("bulk_cell_component", MaterialItem::new);
    public static final ItemDefinition<MEGABulkCell> BULK_ITEM_CELL = MEGAItems.item("bulk_item_cell", MEGABulkCell::new);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_ITEM_CELL_1M = MEGAItems.portable(MEGATier._1M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_ITEM_CELL_4M = MEGAItems.portable(MEGATier._4M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_ITEM_CELL_16M = MEGAItems.portable(MEGATier._16M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_ITEM_CELL_64M = MEGAItems.portable(MEGATier._64M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_ITEM_CELL_256M = MEGAItems.portable(MEGATier._256M, MEGACellType.ITEM);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_FLUID_CELL_1M = MEGAItems.portable(MEGATier._1M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_FLUID_CELL_4M = MEGAItems.portable(MEGATier._4M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_FLUID_CELL_16M = MEGAItems.portable(MEGATier._16M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_FLUID_CELL_64M = MEGAItems.portable(MEGATier._64M, MEGACellType.FLUID);
    public static final ItemDefinition<MEGAPortableCell> PORTABLE_FLUID_CELL_256M = MEGAItems.portable(MEGATier._256M, MEGACellType.FLUID);

    public static void init() {
    }

    public static List<ItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    private static ItemDefinition<StorageComponentItem> component(MEGATier tier) {
        return MEGAItems.item("cell_component_" + tier.affix, p -> new StorageComponentItem(p, tier.kbFactor()));
    }

    private static ItemDefinition<MEGAStorageCell> cell(MEGATier tier, IMEGACellType type) {
        return MEGAItems.item(type.affix() + "_storage_cell_" + tier.affix, p -> new MEGAStorageCell((Item.Properties)p, tier, type));
    }

    private static ItemDefinition<MEGAPortableCell> portable(MEGATier tier, IMEGACellType type) {
        return MEGAItems.item("portable_" + type.affix() + "_cell_" + tier.affix, p -> new MEGAPortableCell((Item.Properties)p, tier, type));
    }

    private static <T extends Item> ItemDefinition<T> item(String id, Function<Item.Properties, T> factory) {
        Item.Properties p = new Item.Properties().m_41491_(MEGACells.CREATIVE_TAB);
        Item item = (Item)factory.apply(p);
        ItemDefinition<Item> definition = new ItemDefinition<Item>(MEGACells.makeId(id), item);
        ITEMS.add(definition);
        return definition;
    }

    public static class ItemDefinition<T extends Item>
    implements ItemLike {
        private final ResourceLocation id;
        private final T item;

        public ItemDefinition(ResourceLocation id, T item) {
            Objects.requireNonNull(id);
            this.id = id;
            this.item = item;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        @NotNull
        public final T m_5456_() {
            return this.item;
        }
    }
}

