/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.data.LootBuilders;
import io.github.noeppi_noeppi.libx.impl.data.LootData;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockLootProviderBase
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ModX mod;
    protected final DataGenerator generator;
    private final Set<Block> ignored = new HashSet<Block>();
    private final Map<Block, Function<Block, LootTable.Builder>> functionMap = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProviderBase(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    protected void customLootTable(Block block) {
        this.ignored.add(block);
    }

    protected void customLootTable(Block block, LootTable.Builder loot) {
        this.functionMap.put(block, b -> loot);
    }

    protected void customLootTable(Block block, Function<Block, LootTable.Builder> loot) {
        this.functionMap.put(block, loot);
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " block loot tables";
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        this.setup();
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (ResourceLocation resourceLocation : ForgeRegistries.BLOCKS.getKeys()) {
            Function<Block, LootTable.Builder> loot;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (block == null || !this.mod.modid.equals(resourceLocation.m_135827_()) || this.ignored.contains(block)) continue;
            if (this.functionMap.containsKey(block)) {
                loot = this.functionMap.get(block);
            } else {
                LootTable.Builder builder = this.defaultBehavior(block);
                Function<Block, LootTable.Builder> function = loot = builder == null ? null : b -> builder;
            }
            if (loot == null) continue;
            tables.put(resourceLocation, loot.apply(block));
        }
        for (Map.Entry entry : tables.entrySet()) {
            Path path = BlockLootProviderBase.getPath(this.generator.m_123916_(), (ResourceLocation)entry.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)entry.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path);
        }
    }

    protected abstract void setup();

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    public LootModifier copyNBT(String ... tags) {
        return (b, entry) -> {
            CopyNbtFunction.Builder func = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
            for (String tag : tags) {
                func = func.m_80279_(tag, "BlockEntityTag." + tag);
            }
            return entry.m_5577_((LootItemFunction.Builder)func);
        };
    }

    public LootModifier copyProperties(Property<?> ... properties) {
        return (b, entry) -> {
            CopyBlockState.Builder func = CopyBlockState.m_80062_((Block)b);
            for (Property property : properties) {
                func = func.m_80084_(property);
            }
            return entry.m_5577_((LootItemFunction.Builder)func);
        };
    }

    public void drops(Block b, boolean silk, ItemStack ... drops) {
        LootFactory[] loot = new LootFactory[drops.length];
        for (int i = 0; i < drops.length; ++i) {
            loot[i] = this.stack(drops[i]);
        }
        this.drops(b, silk, loot);
    }

    public void drops(Block b, boolean silk, LootPoolEntryContainer.Builder<?> ... loot) {
        this.drops(b, silk, LootFactory.from(loot));
    }

    public void drops(Block b, boolean silk, LootFactory ... loot) {
        this.drops(b, silk ? this.silk(LootModifier.identity()) : this.noSilk(), loot);
    }

    public void drops(Block b, LootFactory ... loot) {
        this.drops(b, this.noSilk(), loot);
    }

    public void drops(Block b, SilkModifier silk, LootFactory ... loot) {
        LootPoolEntryContainer.Builder<?> entry = this.combine(LootFactory.resolve(b, loot));
        if (silk.modifier != null) {
            LootPoolEntryContainer.Builder<?> silkBuilder = silk.modifier.apply(b, (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_(this.silkCondition()));
            entry = LootBuilders.alternative(silkBuilder, entry);
        }
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry).m_6509_(ExplosionCondition.m_81661_());
        this.customLootTable(b, LootTable.m_79147_().m_79161_(pool));
    }

    public SimpleLootFactory item() {
        return SimpleLootFactory.item();
    }

    public SilkModifier silk(GenericLootModifier modifier) {
        return new SilkModifier(modifier);
    }

    public SilkModifier noSilk() {
        return new SilkModifier(null);
    }

    public LootFactory repeat(LootFactory factory, int times) {
        LootFactory[] factories = new LootFactory[times];
        for (int i = 0; i < times; ++i) {
            factories[i] = factory;
        }
        return this.combine(factories);
    }

    public WrappedLootEntry from(LootPoolSingletonContainer.Builder<?> entry) {
        return new WrappedLootEntry(entry);
    }

    public LootFactory from(LootPoolEntryContainer.Builder<?> entry) {
        return LootFactory.from(entry);
    }

    public LootModifier from(LootItemConditionalFunction.Builder<?> function) {
        return (b, e) -> e.m_5577_((LootItemFunction.Builder)function);
    }

    public LootModifier fortuneOres() {
        return (b, e) -> e.m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_));
    }

    public LootModifier fortuneUniform() {
        return this.fortuneUniform(1);
    }

    public LootModifier fortuneUniform(int multiplier) {
        return (b, e) -> e.m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)multiplier));
    }

    public LootModifier fortuneBinomial(float probability) {
        return this.fortuneBinomial(probability, 0);
    }

    public LootModifier fortuneBinomial(float probability, int bonus) {
        return (b, e) -> e.m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)probability, (int)bonus));
    }

    public LootItemCondition.Builder random(float chance) {
        return LootItemRandomChanceCondition.m_81927_((float)chance);
    }

    public LootItemCondition.Builder randomFortune(float baseChance) {
        return this.randomFortune(baseChance, baseChance * 1.1111112f, baseChance * 1.25f, baseChance * 1.6666666f, baseChance * 5.0f);
    }

    public LootItemCondition.Builder randomFortune(float baseChance, float ... levelChances) {
        float[] chances = new float[levelChances.length + 1];
        chances[0] = baseChance;
        System.arraycopy(levelChances, 0, chances, 1, levelChances.length);
        return BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances);
    }

    public LootModifier count(int count) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public LootModifier count(int min, int max) {
        if (min == max) {
            return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        }
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootModifier countBinomial(float chance, int num) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)num, (float)chance)));
    }

    public LootItemCondition.Builder not(LootItemCondition.Builder condition) {
        return InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)condition);
    }

    public LootItemCondition.Builder or(LootItemCondition.Builder ... conditions) {
        return AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])conditions);
    }

    public LootPoolEntryContainer.Builder<?> combine(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::all, loot);
    }

    public LootFactory combine(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::all, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> random(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::group, loot);
    }

    public LootFactory random(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::group, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> first(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::alternative, loot);
    }

    public LootFactory first(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::alternative, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> whileMatch(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::sequence, loot);
    }

    public LootFactory whileMatch(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::sequence, l -> l.build(e), loot);
    }

    public WrappedLootEntry stack(ItemLike item) {
        return new WrappedLootEntry(LootItem.m_79579_((ItemLike)item));
    }

    public MatchToolBuilder matchTool(ItemLike item) {
        return new MatchToolBuilder(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}));
    }

    public MatchToolBuilder matchTool(TagKey<Item> item) {
        return new MatchToolBuilder(ItemPredicate.Builder.m_45068_().m_204145_(item));
    }

    public LootItemCondition.Builder silkCondition() {
        ItemPredicate.Builder predicate = ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)));
        return MatchTool.m_81997_((ItemPredicate.Builder)predicate);
    }

    public WrappedLootEntry stack(ItemStack stack) {
        return new WrappedLootEntry(LootData.stack(stack));
    }

    @Nullable
    protected LootTable.Builder defaultBehavior(Block b) {
        if (b.m_49965_().m_61056_().stream().anyMatch(this::needsLootTable)) {
            LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
            LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_6509_(ExplosionCondition.m_81661_());
            return LootTable.m_79147_().m_79161_(pool);
        }
        return null;
    }

    protected boolean needsLootTable(BlockState state) {
        return !state.m_60795_() && state.m_60819_().m_76188_().m_60734_() != state.m_60734_() && !BuiltInLootTables.f_78712_.equals((Object)state.m_60734_().m_60589_());
    }

    @FunctionalInterface
    public static interface LootModifier
    extends GenericLootModifier,
    SimpleLootFactory {
        public static LootModifier identity() {
            return (b, e) -> e;
        }

        public static LootModifier chain(LootModifier ... children) {
            if (children.length == 0) {
                return LootModifier.identity();
            }
            if (children.length == 1) {
                return children[0];
            }
            return (b, e) -> {
                LootPoolSingletonContainer.Builder<?> entry = e;
                for (LootModifier modifier : children) {
                    entry = modifier.apply(b, entry);
                }
                return entry;
            };
        }

        public LootPoolSingletonContainer.Builder<?> apply(Block var1, LootPoolSingletonContainer.Builder<?> var2);

        @Override
        default public LootPoolSingletonContainer.Builder<?> build(Block block) {
            return this.apply(block, SimpleLootFactory.item().build(block));
        }

        default public LootModifier andThen(LootModifier other) {
            return LootModifier.chain(this, other);
        }
    }

    @FunctionalInterface
    public static interface LootFactory {
        public static LootFactory from(LootPoolEntryContainer.Builder<?> builder) {
            return b -> builder;
        }

        public static LootFactory[] from(LootPoolEntryContainer.Builder<?>[] builders) {
            LootFactory[] factories = new LootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                LootPoolEntryContainer.Builder<?> builder = builders[i];
                factories[i] = b -> builder;
            }
            return factories;
        }

        public static LootPoolEntryContainer.Builder<?>[] resolve(Block b, LootFactory[] factories) {
            LootPoolEntryContainer.Builder[] entries = new LootPoolEntryContainer.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(b);
            }
            return entries;
        }

        public LootPoolEntryContainer.Builder<?> build(Block var1);

        default public LootFactory with(LootItemCondition.Builder ... conditions) {
            return b -> {
                LootPoolEntryContainer.Builder<?> entry = this.build(b);
                for (LootItemCondition.Builder condition : conditions) {
                    entry.m_6509_(condition);
                }
                return entry;
            };
        }
    }

    public static class WrappedLootEntry
    implements SimpleLootFactory {
        public final LootPoolSingletonContainer.Builder<?> entry;

        private WrappedLootEntry(LootPoolSingletonContainer.Builder<?> entry) {
            this.entry = entry;
        }

        @Override
        public LootPoolSingletonContainer.Builder<?> build(Block block) {
            return this.entry;
        }
    }

    @FunctionalInterface
    public static interface GenericLootModifier
    extends LootFactory {
        public static GenericLootModifier identity() {
            return (b, e) -> e;
        }

        public LootPoolEntryContainer.Builder<?> apply(Block var1, LootPoolSingletonContainer.Builder<?> var2);

        @Override
        default public LootPoolEntryContainer.Builder<?> build(Block block) {
            return this.apply(block, SimpleLootFactory.item().build(block));
        }
    }

    public static class SilkModifier {
        @Nullable
        public final GenericLootModifier modifier;

        private SilkModifier(@Nullable GenericLootModifier modifier) {
            this.modifier = modifier;
        }
    }

    @FunctionalInterface
    public static interface SimpleLootFactory
    extends LootFactory {
        public static SimpleLootFactory item() {
            return LootItem::m_79579_;
        }

        public static SimpleLootFactory from(LootPoolSingletonContainer.Builder<?> builder) {
            return b -> builder;
        }

        public static SimpleLootFactory[] from(LootPoolSingletonContainer.Builder<?>[] builders) {
            SimpleLootFactory[] factories = new SimpleLootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                LootPoolSingletonContainer.Builder<?> builder = builders[i];
                factories[i] = b -> builder;
            }
            return factories;
        }

        public static LootPoolSingletonContainer.Builder<?>[] resolve(Block b, SimpleLootFactory[] factories) {
            LootPoolSingletonContainer.Builder[] entries = new LootPoolSingletonContainer.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(b);
            }
            return entries;
        }

        public LootPoolSingletonContainer.Builder<?> build(Block var1);

        default public LootFactory withFinal(GenericLootModifier finalModifier) {
            return b -> finalModifier.apply(b, this.build(b));
        }

        default public SimpleLootFactory with(LootModifier ... modifiers) {
            LootModifier chained = LootModifier.chain(modifiers);
            return b -> chained.apply(b, this.build(b));
        }

        @Override
        default public SimpleLootFactory with(LootItemCondition.Builder ... conditions) {
            return b -> {
                LootPoolSingletonContainer.Builder<?> entry = this.build(b);
                for (LootItemCondition.Builder condition : conditions) {
                    entry.m_6509_(condition);
                }
                return entry;
            };
        }

        default public SimpleLootFactory with(LootItemConditionalFunction.Builder<?> ... functions) {
            LootModifier[] modifiers = new LootModifier[functions.length];
            for (int i = 0; i < functions.length; ++i) {
                LootItemConditionalFunction.Builder<?> function = functions[i];
                modifiers[i] = (b, e) -> e.m_5577_((LootItemFunction.Builder)function);
            }
            LootModifier chained = LootModifier.chain(modifiers);
            return b -> chained.apply(b, this.build(b));
        }
    }

    public static class MatchToolBuilder
    implements LootItemCondition.Builder {
        private final ItemPredicate.Builder builder;

        private MatchToolBuilder(ItemPredicate.Builder builder) {
            this.builder = builder;
        }

        @Nonnull
        public LootItemCondition m_6409_() {
            return MatchTool.m_81997_((ItemPredicate.Builder)this.builder).m_6409_();
        }

        public MatchToolBuilder ench(Enchantment ench) {
            return this.ench(ench, MinMaxBounds.Ints.m_55386_((int)1));
        }

        public MatchToolBuilder ench(Enchantment ench, int minLevel) {
            return this.ench(ench, MinMaxBounds.Ints.m_55386_((int)minLevel));
        }

        public MatchToolBuilder enchExact(Enchantment ench, int level) {
            return this.ench(ench, MinMaxBounds.Ints.m_55371_((int)level));
        }

        private MatchToolBuilder ench(Enchantment ench, MinMaxBounds.Ints bounds) {
            this.builder.m_45071_(new EnchantmentPredicate(ench, bounds));
            return this;
        }

        public MatchToolBuilder nbt(CompoundTag nbt) {
            this.builder.m_45075_(nbt);
            return this;
        }
    }
}

