/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.config.Group;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ConfigGroup {
    public final Class<?> type;
    public final List<String> path;
    public final List<String> comment;
    public static final Comparator<ConfigGroup> BY_PATH = (o1, o2) -> {
        int minLength = Math.min(o1.path.size(), o2.path.size());
        for (int i = 0; i < minLength; ++i) {
            int result = o1.path.get(i).compareTo(o2.path.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.path.size(), o2.path.size());
    };

    public ConfigGroup(Class<?> type, ImmutableList<String> path, ImmutableList<String> comment) {
        this.type = type;
        this.path = path;
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigGroup that = (ConfigGroup)o;
        return this.type.equals(that.type) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.path);
    }

    @Nullable
    public static ConfigGroup create(Class<?> type, Class<?> configBaseClass) {
        try {
            if (!Modifier.isStatic(type.getModifiers())) {
                return null;
            }
            if (type.equals(configBaseClass)) {
                return new ConfigGroup(type, (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
            }
            Group group = type.getAnnotation(Group.class);
            ArrayList<String> path = new ArrayList<String>();
            path.add(0, type.getSimpleName());
            for (Class<?> currentStep = type.getDeclaringClass(); currentStep != configBaseClass; currentStep = currentStep.getDeclaringClass()) {
                if (currentStep == null || currentStep == Object.class) {
                    throw new IllegalStateException("LibX config internal error: Can't create config group for class that is not part of config base class.");
                }
                path.add(0, currentStep.getSimpleName());
            }
            return new ConfigGroup(type, (ImmutableList<String>)ImmutableList.copyOf(path), (ImmutableList<String>)(group == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])group.value())));
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Failed to create config group for type " + type, e);
        }
    }
}

