/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common;

import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import xyz.jpenilla.minimotd.common.IconManager;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.ConfigManager;
import xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;
import xyz.jpenilla.minimotd.common.util.Components;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public final class MiniMOTD<I> {
    private final ConfigManager configManager;
    private final IconManager<I> iconManager;
    private final MiniMOTDPlatform<I> platform;

    public MiniMOTD(MiniMOTDPlatform<I> platform) {
        this.platform = platform;
        try {
            this.iconManager = new IconManager(this);
            this.configManager = new ConfigManager(this);
            this.configManager.loadConfigs();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to load MiniMOTD. Ensure your config files are without errors.", ex);
        }
    }

    public MiniMOTDPlatform<I> platform() {
        return this.platform;
    }

    public Path dataDirectory() {
        return this.platform.dataDirectory();
    }

    public IconManager<I> iconManager() {
        return this.iconManager;
    }

    public Logger logger() {
        return this.platform.logger();
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public PingResponse<I> createMOTD(MiniMOTDConfig config, int onlinePlayers, int maxPlayers) {
        PingResponse.PlayerCount count = config.modifyPlayerCount(onlinePlayers, maxPlayers);
        PingResponse.Builder<I> response = PingResponse.builder().playerCount(count).disablePlayerListHover(config.disablePlayerListHover()).hidePlayerCount(config.hidePlayerCount());
        String iconString = null;
        if (config.motdEnabled()) {
            if (config.motds().isEmpty()) {
                throw new IllegalStateException("MOTD is enabled, but there are no MOTDs in the config file?");
            }
            int index = config.motds().size() == 1 ? 0 : ThreadLocalRandom.current().nextInt(config.motds().size());
            MiniMOTDConfig.MOTD motdConfig = config.motds().get(index);
            TextComponent motd = Components.ofChildren(MiniMOTD.parse(motdConfig.line1(), count), Component.newline(), MiniMOTD.parse(motdConfig.line2(), count));
            response.motd(motd);
            iconString = motdConfig.icon();
        }
        if (config.iconEnabled()) {
            response.icon(this.iconManager().icon(iconString));
        }
        return response.build();
    }

    private static Component parse(String input, PingResponse.PlayerCount count) {
        String online = Integer.toString(count.onlinePlayers());
        String max = Integer.toString(count.maxPlayers());
        return MiniMessage.miniMessage().deserialize(MiniMOTD.replacePlayerCount(input, online, max), TagResolver.resolver(Placeholder.unparsed("online_players", online), Placeholder.unparsed("max_players", max)));
    }

    private static String replacePlayerCount(String input, String online, String max) {
        return input.replace("{onlinePlayers}", online).replace("{maxPlayers}", max);
    }

    public synchronized void reload() {
        this.iconManager.loadIcons();
        this.configManager.loadConfigs();
        this.platform.onReload();
    }
}

