/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.forge;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Bindings;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.jpenilla.minimotd.common.CommandHandler;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.forge.util.ComponentConverter;

@Mod(value="minimotd_reforged")
public final class MiniMOTDForge
implements MiniMOTDPlatform<String> {
    private static MiniMOTDForge instance = null;
    private final Logger logger = LoggerFactory.getLogger(MiniMOTD.class);
    private final Path dataDirectory = FMLPaths.CONFIGDIR.get().resolve("minimotd");
    private final MiniMOTD<String> miniMOTD;
    private MinecraftServer server;

    public MiniMOTDForge() {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.miniMOTD = null;
            return;
        }
        if (instance != null) {
            throw new IllegalStateException("Cannot create a second instance of " + this.getClass().getName());
        }
        instance = this;
        ((IEventBus)Bindings.getForgeBus().get()).register((Object)this);
        this.miniMOTD = new MiniMOTD<String>(this);
        this.miniMOTD.logger().info("Done initializing MiniMOTD");
    }

    public @NonNull MiniMOTD<String> miniMOTD() {
        return this.miniMOTD;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        this.server = event.getServer();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent event) {
        this.server = null;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent event) {
        CommandHandler handler = new CommandHandler(this.miniMOTD);
        final class WrappingExecutor
        implements Command<CommandSourceStack> {
            private final CommandHandler.Executor handler;

            WrappingExecutor(CommandHandler.Executor handler) {
                this.handler = handler;
            }

            public int run(@NonNull CommandContext<CommandSourceStack> context) {
                this.handler.execute((text, success) -> {
                    CommandSourceStack source = (CommandSourceStack)context.getSource();
                    if (success) {
                        source.m_81354_(ComponentConverter.toNative(text), false);
                    } else {
                        source.m_81352_(ComponentConverter.toNative(text));
                    }
                });
                return 1;
            }
        }
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"minimotd").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"reload").executes((Command)new WrappingExecutor(handler::reload)))).then(Commands.m_82127_((String)"about").executes((Command)new WrappingExecutor(handler::about)))).then(Commands.m_82127_((String)"help").executes((Command)new WrappingExecutor(handler::help))));
    }

    public static @NonNull MiniMOTDForge get() {
        return instance;
    }

    public @NonNull MinecraftServer requireServer() {
        if (this.server == null) {
            throw new IllegalStateException("Server requested before started");
        }
        return this.server;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull String loadIcon(@NonNull BufferedImage bufferedImage) throws Exception {
        String icon;
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
            ByteBuffer base64 = Base64.getEncoder().encode(byteBuf.nioBuffer());
            icon = "data:image/png;base64," + StandardCharsets.UTF_8.decode(base64);
        }
        finally {
            byteBuf.release();
        }
        return icon;
    }
}

