/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.forge.mixin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;
import xyz.jpenilla.minimotd.forge.MiniMOTDForge;
import xyz.jpenilla.minimotd.forge.util.ComponentConverter;

@Mixin(value={ServerStatusPacketListenerImpl.class})
abstract class ServerStatusPacketListenerImplMixin {
    ServerStatusPacketListenerImplMixin() {
    }

    @Redirect(method={"handleStatusRequest"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getStatus()Lnet/minecraft/network/protocol/status/ServerStatus;"))
    public ServerStatus injectHandleStatusRequest(MinecraftServer server) {
        try {
            MiniMOTDForge miniMOTDForge = MiniMOTDForge.get();
            ServerStatus status = Objects.requireNonNull(server.m_129928_(), "status");
            MiniMOTD<String> miniMOTD = miniMOTDForge.miniMOTD();
            MiniMOTDConfig config = miniMOTD.configManager().mainConfig();
            PingResponse<String> response = miniMOTD.createMOTD(config, server.m_7416_(), server.m_7418_());
            response.motd(motd -> status.m_134908_(ComponentConverter.toNative(motd)));
            response.icon(arg_0 -> ((ServerStatus)status).m_134906_(arg_0));
            if (response.hidePlayerCount()) {
                status.m_134910_(null);
            } else {
                ServerStatus.Players newPlayers = new ServerStatus.Players(response.playerCount().maxPlayers(), response.playerCount().onlinePlayers());
                if (!response.disablePlayerListHover()) {
                    ArrayList players = new ArrayList(server.m_6846_().m_11314_());
                    Collections.shuffle(players);
                    GameProfile[] gameProfiles = (GameProfile[])players.stream().map(Player::m_36316_).limit(12L).toArray(GameProfile[]::new);
                    newPlayers.m_134924_(gameProfiles);
                }
                status.m_134910_(newPlayers);
            }
            return status;
        }
        catch (Exception e) {
            MiniMOTDForge.get().logger().error("Error processing motd", (Throwable)e);
            throw e;
        }
    }
}

