/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.lib.com.typesafe.config.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import xyz.jpenilla.minimotd.lib.com.typesafe.config.ConfigOrigin;
import xyz.jpenilla.minimotd.lib.com.typesafe.config.ConfigValueType;
import xyz.jpenilla.minimotd.lib.com.typesafe.config.impl.ConfigNumber;
import xyz.jpenilla.minimotd.lib.com.typesafe.config.impl.SerializedConfigValue;

final class ConfigDouble
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double value;

    ConfigDouble(ConfigOrigin origin, double value, String originalText) {
        super(origin, originalText);
        this.value = value;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Double unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s = super.transformToString();
        if (s == null) {
            return Double.toString(this.value);
        }
        return s;
    }

    @Override
    protected long longValue() {
        return (long)this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigDouble newCopy(ConfigOrigin origin) {
        return new ConfigDouble(origin, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

