/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.object;

import com.blamejared.contenttweaker.core.api.object.ObjectFactory;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

@FunctionalInterface
public interface ObjectFactoryMapping<T, U extends ObjectFactory<T>> {
    public Class<U> type();

    default public U of() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType constructorType = MethodType.methodType(Void.TYPE);
            MethodHandle constructor = lookup.findConstructor(this.type(), constructorType);
            return (U)((ObjectFactory)GenericUtil.uncheck((Object)constructor.invoke()));
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to construct class '" + this.type().getName() + "' due to an invocation error", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to construct class '" + this.type().getName() + "' due to a construction error", e);
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new RuntimeException("%s: %s".formatted(e.getClass().getName(), e.getMessage()), e);
        }
    }
}

