/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.object;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface ObjectHolder<T>
extends Supplier<T> {
    public static <T> ObjectHolder<T> of(final ObjectType<T> type, final ResourceLocation id, final Supplier<T> objectCreator) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(id);
        Objects.requireNonNull(objectCreator);
        return new ObjectHolder<T>(){

            @Override
            public ObjectType<T> type() {
                return type;
            }

            @Override
            public ResourceLocation id() {
                return id;
            }

            @Override
            public T get() {
                return objectCreator.get();
            }

            public String toString() {
                return "%s/%s".formatted(this.type(), this.id());
            }
        };
    }

    public ObjectType<T> type();

    public ResourceLocation id();

    @Override
    public T get();
}

