/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.object;

import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ObjectType<T> {
    public static <T> ObjectType<T> of(ResourceKey<? extends Registry<T>> key, Class<T> type) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        return ObjectType.of(key.m_135782_(), key, type);
    }

    public static <T> ObjectType<T> of(ResourceLocation id, Class<T> type) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(type);
        return ObjectType.of(id, null, type);
    }

    public static <T> ObjectType<T> of(final ResourceLocation id, final @Nullable ResourceKey<? extends Registry<T>> key, final Class<T> type) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(type, "type");
        final char typeMarker = key == null ? (char)'S' : 'R';
        return new ObjectType<T>(){

            @Override
            public ResourceLocation id() {
                return id;
            }

            @Override
            public ResourceKey<? extends Registry<T>> key() {
                return key;
            }

            @Override
            public Class<T> type() {
                return type;
            }

            public String toString() {
                return "%s[%s]{%s}".formatted(this.id(), Character.valueOf(typeMarker), this.type().getName());
            }
        };
    }

    public ResourceLocation id();

    @Nullable
    public ResourceKey<? extends Registry<T>> key();

    public Class<T> type();
}

