/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.object;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface RegistryResolver<T>
extends Function<ResourceLocation, T> {
    public static <T> RegistryResolver<T> of(ObjectType<T> type) {
        ResourceKey key = Objects.requireNonNull(Objects.requireNonNull(type).key());
        return RegistryResolver.of(type, () -> GameRegistry.findFromKey(type, key));
    }

    public static <T> RegistryResolver<T> of(final ObjectType<T> type, java.util.function.Supplier<? extends GameRegistry<T>> registryResolver) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(registryResolver);
        Supplier resolver = Suppliers.memoize(registryResolver::get);
        return new RegistryResolver<T>((java.util.function.Supplier)resolver){
            final /* synthetic */ java.util.function.Supplier val$resolver;
            {
                this.val$resolver = supplier;
            }

            @Override
            public ObjectType<T> type() {
                return type;
            }

            @Override
            public GameRegistry<T> registry() {
                return (GameRegistry)this.val$resolver.get();
            }
        };
    }

    public ObjectType<T> type();

    public GameRegistry<T> registry();

    default public T resolve(ResourceLocation id) {
        return this.registry().get(Objects.requireNonNull(id));
    }

    default public ResourceLocation nameOf(T object) {
        return this.registry().nameOf(Objects.requireNonNull(object));
    }

    default public void enqueueRegistration(ResourceLocation name, java.util.function.Supplier<T> objectCreator) {
        this.registry().enqueueRegistration(name, objectCreator);
    }

    default public void enqueueRegistration(ObjectHolder<T> holder) {
        this.registry().enqueueRegistration(holder);
    }

    @Override
    default public T apply(ResourceLocation location) {
        return this.resolve(location);
    }
}

