/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.registry;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface GameRegistry<T> {
    public static <T> GameRegistry<T> findFromKey(ObjectType<T> type, ResourceKey<? extends Registry<T>> key) {
        return ContentTweakerApi.get().getOrCreateRegistryFromKey(type, key);
    }

    public ObjectType<T> type();

    public T get(ResourceLocation var1);

    public ResourceLocation nameOf(T var1);

    public Collection<T> all();

    public void enqueueRegistration(ResourceLocation var1, Supplier<T> var2);

    default public void enqueueRegistration(ObjectHolder<T> holder) {
        this.enqueueRegistration(holder.id(), holder);
    }

    default public Stream<T> stream() {
        return this.all().stream();
    }
}

