/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.util;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ClassArchitect<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private final Map<Class<? extends T>, MethodHandle> constructors = new HashMap<Class<? extends T>, MethodHandle>();
    private final MethodType constructorTarget;

    private ClassArchitect(MethodType constructorTarget) {
        this.constructorTarget = constructorTarget;
    }

    public static <T> ClassArchitect<T> of(MethodType constructorTarget) {
        Objects.requireNonNull(constructorTarget);
        return new ClassArchitect<T>(constructorTarget);
    }

    public static <T> ClassArchitect<T> of(Class<?> ... constructorParameters) {
        return ClassArchitect.of(MethodType.methodType(Void.TYPE, constructorParameters));
    }

    public <U extends T> U construct(Class<U> clazz) {
        return this.construct(clazz, null);
    }

    public <U extends T> U construct(Class<U> clazz, Object ... constructorParameters) {
        try {
            Objects.requireNonNull(clazz);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ClassCastException(Integer.toString(clazz.getModifiers()));
            }
            MethodHandle target = this.constructors.computeIfAbsent(clazz, this::findConstructor);
            return (U)GenericUtil.uncheck((Object)target.invokeWithArguments(constructorParameters));
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to construct class '" + clazz.getName() + "' due to an invocation error", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to construct class '" + clazz.getName() + "' due to a construction error", e);
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new RuntimeException("%s: %s".formatted(e.getClass().getName(), e.getMessage()), e);
        }
    }

    private <U extends T> MethodHandle findConstructor(Class<U> clazz) {
        try {
            return LOOKUP.findConstructor(clazz, this.constructorTarget);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to identify constructor for class '" + clazz.getName() + "' due to a reflective error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

