/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.bracket;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;

public final class BracketHelper {
    private BracketHelper() {
    }

    public static ResourceLocation locationOrThrow(CodePosition position, String in) throws ParseException {
        return BracketHelper.locationOrThrow(position, in, () -> "Unable to convert given string \"" + in + "\" to resource location");
    }

    public static ResourceLocation locationOrThrow(CodePosition position, String in, Supplier<String> message) throws ParseException {
        Objects.requireNonNull(position);
        Objects.requireNonNull(message);
        try {
            return new ResourceLocation(Objects.requireNonNull(in, "null"));
        }
        catch (NullPointerException | ResourceLocationException e) {
            throw new ParseException(position, message.get(), e);
        }
    }

    public static ParsedExpression locationArgument(CodePosition position, ResourceLocation location) {
        Objects.requireNonNull(position);
        Objects.requireNonNull(location);
        ParsedExpression receiver = ParseUtil.staticMemberExpression((CodePosition)position, (String)"contenttweaker.resource.ResourceLocation");
        ParsedExpressionMember of = new ParsedExpressionMember(position, receiver, "of", null);
        ParsedExpressionString namespace = new ParsedExpressionString(position, location.m_135827_(), false);
        ParsedExpressionString path = new ParsedExpressionString(position, location.m_135815_(), false);
        ParsedCallArguments arguments = new ParsedCallArguments(null, List.of(namespace, path));
        return new ParsedExpressionCall(position, (ParsedExpression)of, arguments);
    }

    public static <F> F parseToCompile(CodePosition position, ParseOperation<F> operation) throws CompileException {
        try {
            return operation.execute();
        }
        catch (ParseException e) {
            CompileException exception = new CompileException(position, CompileExceptionCode.PARSE_ERROR, e.message);
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public static <T> Supplier<Stream<String>> dumpAllOf(String bracket, ObjectType<T> type) {
        return BracketHelper.dumpAllOf(bracket, type, ResourceLocation::toString);
    }

    public static <T> Supplier<Stream<String>> dumpAllOf(String bracket, ObjectType<T> type, Function<ResourceLocation, String> idToString) {
        Objects.requireNonNull(bracket);
        Objects.requireNonNull(type);
        Objects.requireNonNull(idToString);
        String bracketFormat = "<" + bracket + ":%s>";
        return () -> {
            GameRegistry registry = ContentTweakerApi.get().registry().findResolver(type).registry();
            return registry.all().stream().map(registry::nameOf).map(idToString).filter(Objects::nonNull).map(xva$0 -> bracketFormat.formatted(xva$0));
        };
    }

    @FunctionalInterface
    public static interface ParseOperation<T> {
        public T execute() throws ParseException;
    }
}

