/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.bracket;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.IZenClassRegistry;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.type.IParsedType;

public final class ReferenceExpression<T, U extends Reference<T>>
extends ParsedExpression {
    private final ObjectType<T> objectType;
    private final TypeToken<U> referenceToken;
    private final ResourceLocation objectId;

    public ReferenceExpression(CodePosition position, ObjectType<T> objectType, TypeToken<U> referenceToken, ResourceLocation objectId) {
        super(Objects.requireNonNull(position));
        this.objectType = Objects.requireNonNull(objectType);
        this.referenceToken = ReferenceExpression.checkToken(Objects.requireNonNull(referenceToken));
        this.objectId = Objects.requireNonNull(objectId);
    }

    private static <R> TypeToken<R> checkToken(TypeToken<R> token) {
        Type type = token.getType();
        if (!(type instanceof Class) && !(type instanceof ParameterizedType)) {
            throw new IllegalStateException(token + " represents type " + type + " which is unsupported");
        }
        return token;
    }

    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        ParsedExpression metaFactory = ParseUtil.staticMemberExpression((CodePosition)this.position, (String)"contenttweaker._rt.MetaFactory");
        ParsedExpressionMember of = new ParsedExpressionMember(this.position, metaFactory, "reference", null);
        ParsedCallArguments arguments = new ParsedCallArguments(this.generics(), this.arguments());
        ParsedExpressionCall invocation = new ParsedExpressionCall(this.position, (ParsedExpression)of, arguments);
        return invocation.compile(scope);
    }

    private List<IParsedType> generics() throws CompileException {
        IScriptLoader loader = CraftTweakerAPI.getScriptRunManager().currentRunInfo().loader();
        IZenClassRegistry classes = CraftTweakerAPI.getRegistry().getZenClassRegistry();
        Class<T> objectType = this.objectType.type();
        String objectName = (String)classes.getNameFor(loader, objectType).orElseThrow();
        String referenceName = this.buildGenericReferenceName(loader, classes, objectType);
        IParsedType object = BracketHelper.parseToCompile(this.position, () -> ParseUtil.readParsedType((String)objectName, (CodePosition)this.position));
        IParsedType reference = BracketHelper.parseToCompile(this.position, () -> ParseUtil.readParsedType((String)referenceName, (CodePosition)this.position));
        return List.of(object, reference);
    }

    private String buildGenericReferenceName(IScriptLoader loader, IZenClassRegistry classes, Class<?> objectType) {
        return this.buildGenericReferenceName(loader, classes, this.referenceToken.getType(), objectType);
    }

    private String buildGenericReferenceName(IScriptLoader loader, IZenClassRegistry classes, Type targetType, Class<?> objectType) {
        if (targetType instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)targetType;
            String rawTypeName = this.buildGenericReferenceName(loader, classes, genericType.getRawType(), objectType);
            String generics = Arrays.stream(genericType.getActualTypeArguments()).map(it -> this.buildGenericReferenceName(loader, classes, (Type)it, objectType)).collect(Collectors.joining(", ", "<", ">"));
            return rawTypeName + generics;
        }
        if (targetType instanceof Class) {
            Class rawClass = (Class)targetType;
            return (String)classes.getNameFor(loader, rawClass).orElseThrow();
        }
        if (targetType instanceof TypeVariable) {
            return (String)classes.getNameFor(loader, objectType).orElseThrow();
        }
        throw new IllegalStateException();
    }

    private List<ParsedExpression> arguments() {
        ParsedExpression typeId = BracketHelper.locationArgument(this.position, this.objectType.id());
        ParsedExpression objectId = BracketHelper.locationArgument(this.position, this.objectId);
        return List.of(typeId, objectId);
    }

    public boolean hasStrongType() {
        return true;
    }
}

