/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.object;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.object.Reference")
@ZenRegister(loaders={"contenttweaker"})
public abstract class Reference<T> {
    private final ObjectType<T> type;
    private final ResourceLocation id;
    private T resolved;

    protected Reference(ObjectType<T> type, ResourceLocation id) {
        this.type = type;
        this.id = id;
        this.resolved = null;
    }

    @ZenCodeType.Getter(value="typeId")
    public final ResourceLocation typeId() {
        return this.type.id();
    }

    @ZenCodeType.Getter(value="registryId")
    public final @ZenCodeType.Nullable @Nullable ResourceLocation registryId() {
        return Optional.ofNullable(this.type().key()).map(ResourceKey::m_135782_).orElse(null);
    }

    @ZenCodeType.Getter(value="id")
    public final ResourceLocation id() {
        return this.id;
    }

    public final ObjectType<T> type() {
        return this.type;
    }

    public final T get() {
        if (this.resolved == null) {
            this.resolved = ContentTweakerApi.get().registry().findResolver(this.type()).resolve(this.id());
        }
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve object at this time in %s".formatted(this));
        }
        return this.resolved;
    }

    public String toString() {
        return "Ref(%s/%s)".formatted(this.id(), this.type());
    }
}

