/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.util;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.util.Color")
@ZenRegister(loaders={"contenttweaker"})
public final class Color {
    private final int color;

    private Color(int color) {
        this.color = color;
    }

    @ZenCodeType.Method(value="packedRgba")
    public static Color packedRgba(int color) {
        return new Color(color);
    }

    @ZenCodeType.Method(value="packedRgb")
    public static Color packedRgb(int color) {
        return Color.packedRgba(color << 8 | 0xFF);
    }

    @ZenCodeType.Method(value="rgba")
    public static Color rgba(int r, int g, int b, int a) {
        return Color.packedRgba((r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF);
    }

    @ZenCodeType.Method(value="rgb")
    public static Color rgb(int r, int g, int b) {
        return Color.rgba(r, g, b, 255);
    }

    @ZenCodeType.Getter(value="r")
    public int r() {
        return this.color >> 24 & 0xFF;
    }

    @ZenCodeType.Getter(value="g")
    public int g() {
        return this.color >> 16 & 0xFF;
    }

    @ZenCodeType.Getter(value="b")
    public int b() {
        return this.color >> 8 & 0xFF;
    }

    @ZenCodeType.Getter(value="a")
    public int a() {
        return this.color & 0xFF;
    }
}

