/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.plugin;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.plugin.ContentTweakerPlugin;
import com.blamejared.contenttweaker.core.api.plugin.ContentTweakerPluginProvider;
import com.blamejared.contenttweaker.core.plugin.DecoratedContentTweakerPlugin;
import com.blamejared.contenttweaker.core.plugin.FactoryMappingRegistrationManager;
import com.blamejared.contenttweaker.core.plugin.ObjectTypeRegistrationManager;
import com.blamejared.contenttweaker.core.plugin.ReferenceFactoryRegistrationManager;
import com.blamejared.contenttweaker.core.plugin.RegistryResolverRegistrationManager;
import com.blamejared.contenttweaker.core.registry.MetaRegistry;
import com.blamejared.contenttweaker.core.registry.ObjectTypeRegistry;
import com.blamejared.contenttweaker.core.util.FreezableList;
import com.blamejared.contenttweaker.core.util.NonApiCraftTweakerWrapper;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.plugin.IBracketParserRegistrationHandler;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public final class PluginManager {
    private final Supplier<List<? extends ContentTweakerPluginProvider>> providers = Suppliers.memoize(this::buildPluginList);

    private PluginManager() {
    }

    public static PluginManager of() {
        return new PluginManager();
    }

    public void initializePlugins(MetaRegistry metaRegistry) {
        ObjectTypeRegistry objectTypeRegistry = metaRegistry.objectTypes();
        objectTypeRegistry.registerTypes(ObjectTypeRegistrationManager.get(this.each(ContentTweakerPluginProvider::registerObjectTypes)));
        metaRegistry.factoryMappings().registerMappings(objectTypeRegistry, FactoryMappingRegistrationManager.get(this.each(ContentTweakerPluginProvider::registerFactoryMappings)));
        metaRegistry.referenceFactories().registerFactories(objectTypeRegistry, ReferenceFactoryRegistrationManager.get(this.each(ContentTweakerPluginProvider::registerReferenceFactories)));
        metaRegistry.registryResolvers().registerResolvers(objectTypeRegistry, RegistryResolverRegistrationManager.get(this.each(ContentTweakerPluginProvider::registerResolvers)));
    }

    public void registerPluginBrackets(IBracketParserRegistrationHandler handler) {
        this.each(ContentTweakerPluginProvider::registerCustomBrackets).accept((name, parser, dumperData) -> handler.registerParserFor("contenttweaker", name, parser, dumperData));
    }

    private List<? extends ContentTweakerPluginProvider> buildPluginList() {
        return FreezableList.of(this.discoverPlugins(), true);
    }

    private List<? extends ContentTweakerPluginProvider> discoverPlugins() {
        return NonApiCraftTweakerWrapper.findClassesWithAnnotation(ContentTweakerPlugin.class).map(this::checkAndCast).map(this::initPlugin).filter(Objects::nonNull).toList();
    }

    private Pair<ResourceLocation, Class<? extends ContentTweakerPluginProvider>> checkAndCast(Class<?> clazz) {
        ResourceLocation id;
        if (!ContentTweakerPluginProvider.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Invalid plugin class annotated with @ContentTweakerPlugin: it must implement ContentTweakerPluginProvider");
        }
        try {
            String targetId = Objects.requireNonNull(clazz.getAnnotation(ContentTweakerPlugin.class)).value();
            id = new ResourceLocation(targetId);
            if (id.m_135827_().equals("minecraft")) {
                throw new ResourceLocationException("Illegal namespace 'minecraft'");
            }
        }
        catch (ResourceLocationException e) {
            throw new IllegalArgumentException("Invalid plugin class ID: not a valid resource location", e);
        }
        return Pair.of((Object)id, clazz);
    }

    private DecoratedContentTweakerPlugin initPlugin(Pair<ResourceLocation, Class<? extends ContentTweakerPluginProvider>> data) {
        try {
            ResourceLocation id = (ResourceLocation)data.getFirst();
            ContentTweakerPluginProvider provider = (ContentTweakerPluginProvider)((Class)data.getSecond()).getConstructor(new Class[0]).newInstance(new Object[0]);
            ContentTweakerCore.LOGGER.info("Successfully identified and loaded plugin {}", (Object)id);
            CraftTweakerAPI.LOGGER.info("CoT: Successfully identified and loaded ContentTweaker plugin {}", (Object)id);
            return new DecoratedContentTweakerPlugin(id, provider);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ContentTweakerCore.LOGGER.error("Unable to load plugin class '" + ((Class)data.getSecond()).getName() + "' due to an error", (Throwable)e);
            return null;
        }
    }

    private <T> Consumer<T> each(BiConsumer<ContentTweakerPluginProvider, T> consumer) {
        Objects.requireNonNull(consumer);
        return t -> this.providers.get().forEach(o -> consumer.accept((ContentTweakerPluginProvider)o, (Object)t));
    }
}

