/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.util.FreezableMap;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ObjectTypeRegistry {
    private final FreezableMap<ResourceLocation, ObjectType<?>> typesById = FreezableMap.of();
    private final FreezableMap<ResourceKey<? extends Registry<?>>, ObjectType<?>> typesByKey = FreezableMap.of();

    ObjectTypeRegistry() {
    }

    public void registerTypes(Map<ResourceLocation, ObjectType<?>> types) {
        this.typesById.putAll(types);
        this.typesById.values().stream().filter(it -> it.key() != null).forEach(it -> this.typesByKey.put(it.key(), (ObjectType<?>)it));
        this.typesById.freeze();
        this.typesByKey.freeze();
    }

    @Nullable
    public <T> ObjectType<T> get(ResourceLocation id) {
        return (ObjectType)GenericUtil.uncheck(this.typesById.get(Objects.requireNonNull(id)));
    }

    @Nullable
    public <T> ObjectType<T> get(ResourceKey<? extends Registry<T>> key) {
        return (ObjectType)GenericUtil.uncheck(this.typesByKey.get(key));
    }

    public Collection<ObjectType<?>> allTypes() {
        return this.typesById.values();
    }
}

