/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.service.ServiceManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.packs.PackType;

final class RuntimeFragment
implements ResourceFragment,
AutoCloseable {
    private final ResourceFragment.Key key;
    private final FileSystemOnDemand fs;
    private final Map<String, LazyResource<?>> lazyResources;
    private final AtomicBoolean finalized;

    private RuntimeFragment(ResourceFragment.Key key, FileSystemOnDemand fs) {
        this.key = key;
        this.fs = fs;
        this.lazyResources = new HashMap();
        this.finalized = new AtomicBoolean(false);
    }

    static RuntimeFragment of(ResourceFragment.Key key) {
        String typeId = switch (key.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PackType.CLIENT_RESOURCES -> "ass";
            case PackType.SERVER_DATA -> "dat";
        };
        String fsId = "%s:%s".formatted(key.id(), typeId);
        FileSystemOnDemand fs = new FileSystemOnDemand(fsId);
        return new RuntimeFragment(key, fs);
    }

    @Override
    public void provideTemplated(String path, String template) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(template);
        Path base = ServiceManager.platform().locateResource("meta", "template");
        Path target = base.resolve(template);
        this.provideTemplated(path, target);
    }

    @Override
    public void provideTemplated(String path, Path template) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(template);
        this.provide(path, (SeekableByteChannel channel) -> this.provide((SeekableByteChannel)channel, template));
    }

    @Override
    public <T> void provideFixed(String path, T resource, ResourceSerializer<T> serializer) {
        if (this.finalized.get()) {
            throw new IllegalStateException("Unable to provide more resources when the file system has been finalized");
        }
        this.provide(Objects.requireNonNull(path), Objects.requireNonNull(Objects.requireNonNull(serializer).serialize(Objects.requireNonNull(resource))));
    }

    @Override
    public <T> void provideOrAlter(String path, Supplier<T> creator, Function<T, T> alterationFunction, ResourceSerializer<T> serializer) {
        if (this.finalized.get()) {
            throw new IllegalStateException("Unable to provide more resources when the file system has been finalized");
        }
        Objects.requireNonNull(path);
        Objects.requireNonNull(creator);
        Objects.requireNonNull(alterationFunction);
        Objects.requireNonNull(serializer);
        LazyResource resource = this.lazyResources.computeIfAbsent(path, it -> new LazyResource(serializer, creator.get()));
        if (resource.serializer() != serializer) {
            throw new IllegalStateException("Given serializer " + serializer + " does not match previous " + resource.serializer());
        }
        LazyResource typedResource = (LazyResource)GenericUtil.uncheck((Object)resource);
        typedResource.update(alterationFunction);
    }

    @Override
    public void close() throws Exception {
        this.fs.close();
    }

    ResourceFragment.Key key() {
        return this.key;
    }

    FileSystem fs() {
        if (!this.finalized.get()) {
            this.fs.finalize(this.lazyResources, this.finalized, this::provide);
        }
        return this.fs0();
    }

    String fsId() {
        return this.fs.id();
    }

    private FileSystem fs0() {
        return this.fs.get();
    }

    private void provide(String path, byte ... resource) {
        this.provide(path, (SeekableByteChannel channel) -> channel.write(ByteBuffer.wrap(Arrays.copyOf(resource, resource.length))));
    }

    private void provide(String path, ExceptionalConsumer<SeekableByteChannel, IOException> consumer) {
        try {
            Path target = this.fs0().getPath(path, new String[0]).toAbsolutePath().normalize();
            Path parent = target.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (SeekableByteChannel channel = Files.newByteChannel(target, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                consumer.accept(channel);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to provide resource for path " + path + " in fragment " + this.key(), e);
        }
    }

    private void provide(SeekableByteChannel outChannel, Path template) throws IOException {
        try (SeekableByteChannel inChannel = Files.newByteChannel(template, StandardOpenOption.READ);){
            int read = 0;
            int estimatedLength = (int)Math.min(inChannel.size(), Integer.MAX_VALUE);
            ByteBuffer buffer = ByteBuffer.allocate(estimatedLength).order(ByteOrder.nativeOrder());
            while (read != -1) {
                read = inChannel.read(buffer);
                if (read > 0) {
                    buffer.flip();
                    outChannel.write(buffer);
                }
                buffer.clear();
            }
        }
    }

    private static final class FileSystemOnDemand
    implements AutoCloseable {
        private final String fsId;
        private volatile boolean initialized;
        private volatile FileSystem fs;

        FileSystemOnDemand(String fsId) {
            this.fsId = Objects.requireNonNull(fsId);
            this.initialized = false;
            this.fs = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            FileSystemOnDemand fileSystemOnDemand = this;
            synchronized (fileSystemOnDemand) {
                if (this.initialized) {
                    this.fs.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileSystem get() {
            if (!this.initialized) {
                FileSystemOnDemand fileSystemOnDemand = this;
                synchronized (fileSystemOnDemand) {
                    if (!this.initialized) {
                        this.fs = this.create();
                        this.initialized = true;
                    }
                }
            }
            return this.fs;
        }

        String id() {
            return this.fsId;
        }

        void finalize(Map<String, LazyResource<?>> lazies, AtomicBoolean finalizedOut, BiConsumer<String, byte[]> provider) {
            if (finalizedOut.get()) {
                throw new IllegalStateException();
            }
            lazies.forEach((path, res) -> provider.accept((String)path, res.provide(ResourceSerializer::serialize)));
            lazies.clear();
            finalizedOut.set(true);
        }

        private FileSystem create() {
            try {
                return FileSystems.newFileSystem(new URI("%s:%s@".formatted("trundle", this.fsId)), Collections.emptyMap());
            }
            catch (IOException | URISyntaxException | FileSystemAlreadyExistsException | ProviderNotFoundException e) {
                Exception cause = e instanceof ProviderNotFoundException ? new IllegalStateException("Injection failed: " + FileSystemProvider.installedProviders(), e) : e;
                throw new RuntimeException("Unable to create file system " + this.fsId, cause);
            }
        }
    }

    @FunctionalInterface
    private static interface ExceptionalConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    private static final class LazyResource<T> {
        private final ResourceSerializer<T> serializer;
        private T current;

        private LazyResource(ResourceSerializer<T> serializer, T current) {
            this.serializer = serializer;
            this.current = current;
        }

        ResourceSerializer<T> serializer() {
            return this.serializer;
        }

        void update(Function<T, T> function) {
            this.current = function.apply(this.current);
        }

        T resource() {
            return this.current;
        }

        byte[] provide(BiFunction<ResourceSerializer<T>, T, byte[]> provider) {
            return provider.apply((ResourceSerializer<ResourceSerializer<T>>)this.serializer(), (ResourceSerializer<T>)this.resource());
        }
    }
}

