/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;

final class RuntimePack {
    private final String name;
    private final String targetNamespace;
    private final PackType type;
    private final JsonObject metadata;
    private final FileSystem fs;

    RuntimePack(String name, String targetNamespace, PackType type, JsonObject metadata, Supplier<FileSystem> fs) {
        this.name = Objects.requireNonNull(name);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        this.type = Objects.requireNonNull(type);
        this.metadata = RuntimePack.validateMeta(Objects.requireNonNull(metadata));
        this.fs = Objects.requireNonNull(Objects.requireNonNull(fs).get());
    }

    private static JsonObject validateMeta(JsonObject object) {
        List<String> invalid = object.entrySet().stream().filter(it -> !(it.getValue() instanceof JsonObject)).map(Map.Entry::getKey).toList();
        if (invalid.isEmpty()) {
            return object;
        }
        throw new IllegalArgumentException("Invalid metadata sections " + invalid + ": not a JsonObject");
    }

    InputStream rootResource(String s) throws IOException {
        Objects.requireNonNull(s);
        if (s.contains("/") || s.contains("\\")) {
            throw new IllegalStateException("Root resources can only be file names");
        }
        return this.resource(s);
    }

    InputStream resource(PackType packType, ResourceLocation resourceLocation) throws IOException {
        Objects.requireNonNull(packType);
        Objects.requireNonNull(resourceLocation);
        if (packType != this.type || !this.targetNamespace.equals(resourceLocation.m_135827_())) {
            return null;
        }
        return this.resource(resourceLocation.m_135815_());
    }

    Collection<ResourceLocation> resources(PackType packType, String s, String s1, int i, Predicate<String> predicate) {
        Objects.requireNonNull(packType);
        Objects.requireNonNull(s);
        Objects.requireNonNull(s1);
        Objects.requireNonNull(predicate);
        if (packType != this.type || !this.targetNamespace.equals(s)) {
            return Collections.emptySet();
        }
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        Path directory = this.pathOf(s1);
        try {
            Files.walkFileTree(directory, Set.of(), i, new ResourceGatherer(directory, p -> resources.add(this.resourceOf(directory.resolve((Path)p)))));
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        return resources;
    }

    boolean knowsResource(PackType packType, ResourceLocation resourceLocation) {
        Objects.requireNonNull(packType);
        Objects.requireNonNull(resourceLocation);
        return packType == this.type && this.targetNamespace.equals(resourceLocation.m_135827_()) && Files.exists(this.pathOf(resourceLocation.m_135815_()), new LinkOption[0]);
    }

    Set<String> namespaces(PackType packType) {
        return this.type == packType ? Set.of(this.targetNamespace) : Collections.emptySet();
    }

    <T> T metadataSection(MetadataSectionSerializer<T> metadataSectionSerializer) {
        String name = metadataSectionSerializer.m_7991_();
        return (T)(this.metadata.has(name) ? metadataSectionSerializer.m_6322_(this.metadata.getAsJsonObject(name)) : null);
    }

    String name() {
        return this.name;
    }

    private InputStream resource(String resource) throws IOException {
        Path path = this.pathOf(resource);
        return Files.exists(path, new LinkOption[0]) ? Files.newInputStream(path, StandardOpenOption.READ) : null;
    }

    private Path pathOf(String resource) {
        return this.fs.getPath(resource, new String[0]).toAbsolutePath();
    }

    private ResourceLocation resourceOf(Path path) {
        return new ResourceLocation(this.targetNamespace, this.fs.getPath("/", new String[0]).relativize(path).toString());
    }

    private static final class ResourceGatherer
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final Consumer<Path> consumer;

        ResourceGatherer(Path root, Consumer<Path> consumer) {
            this.root = Objects.requireNonNull(root);
            Objects.requireNonNull(consumer);
            this.consumer = p -> consumer.accept(p.normalize());
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.visitFile(file, attrs);
            if (result != FileVisitResult.CONTINUE) {
                return result;
            }
            this.consumer.accept(this.root.relativize(file));
            return FileVisitResult.CONTINUE;
        }
    }
}

