/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.resource.RuntimeFragment;
import com.blamejared.contenttweaker.core.resource.RuntimePack;
import com.blamejared.contenttweaker.core.resource.RuntimePackResources;
import com.blamejared.contenttweaker.core.resource.RuntimeResourceManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.GameVersion;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;

public final class RuntimeRepositorySource
implements RepositorySource {
    private final PackType type;

    private RuntimeRepositorySource(PackType type) {
        this.type = type;
    }

    public static RuntimeRepositorySource of(PackType type) {
        Objects.requireNonNull(type);
        return new RuntimeRepositorySource(type);
    }

    public void m_7686_(Consumer<Pack> consumer, Pack.PackConstructor packConstructor) {
        RuntimeResourceManager manager = ContentTweakerCore.core().resourceManager();
        Map<String, RuntimeFragment> resources = manager.fragments(this.type);
        resources.forEach((namespace, fragment) -> consumer.accept(this.pack(this.type, (String)namespace, (RuntimeFragment)fragment, packConstructor)));
    }

    private Pack pack(PackType type, String id, RuntimeFragment fragment, Pack.PackConstructor constructor) {
        String packId = ContentTweakerConstants.rl("runtime/" + fragment.fsId().replace(':', '/')).toString();
        Pack pack = Pack.m_10430_((String)packId, (boolean)true, this.createPack(type, id, packId, fragment), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, this::decorateSource);
        if (pack == null) {
            throw new IllegalStateException("An error occurred while generating runtime ContentTweaker pack '" + packId + "'");
        }
        return pack;
    }

    private Supplier<PackResources> createPack(PackType type, String target, String packId, RuntimeFragment fragment) {
        RuntimePack pack = new RuntimePack(packId, target, type, this.makeMetadata(type, packId, target), fragment::fs);
        return () -> new RuntimePackResources(pack);
    }

    private JsonObject makeMetadata(PackType type, String packId, String target) {
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Runtime pack for " + target + " of type " + type.name());
        pack.addProperty("pack_format", (Number)this.makeFormat(type));
        meta.add("pack", (JsonElement)pack);
        JsonObject cotData = new JsonObject();
        cotData.addProperty("type", type.toString());
        cotData.addProperty("id", packId);
        cotData.addProperty("target", target);
        meta.add(ContentTweakerConstants.rl("data").toString(), (JsonElement)cotData);
        return meta;
    }

    private int makeFormat(PackType type) {
        return type.m_143756_((GameVersion)SharedConstants.m_183709_());
    }

    private Component decorateSource(Component originalName) {
        return new TranslatableComponent("pack.nameAndSource", new Object[]{originalName, new TranslatableComponent(ContentTweakerConstants.ln("pack_source.runtime"))});
    }
}

