/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.resource.RuntimeFragment;
import com.blamejared.contenttweaker.core.service.ServiceManager;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.Logger;

public final class RuntimeResourceDumpingCommand {
    private static final Supplier<Path> DUMP_ROOT = Suppliers.memoize(() -> ServiceManager.platform().gameDirectory().resolve("./ct_dumps/contenttweaker_resources"));

    private RuntimeResourceDumpingCommand() {
    }

    public static void register(ICommandRegistrationHandler handler) {
        handler.registerDump("contenttweaker_resources", (MutableComponent)new TranslatableComponent(ContentTweakerConstants.ln("command.dump_resources.desc")), RuntimeResourceDumpingCommand::buildCommand);
    }

    private static void buildCommand(LiteralArgumentBuilder<CommandSourceStack> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"log").executes(RuntimeResourceDumpingCommand::executeLog))).then(Commands.m_82127_((String)"file").executes(RuntimeResourceDumpingCommand::executeFile))).executes(RuntimeResourceDumpingCommand::executeLog);
    }

    private static int executeLog(CommandContext<CommandSourceStack> context) {
        return RuntimeResourceDumpingCommand.execute(context, arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).info(arg_0));
    }

    private static int executeFile(CommandContext<CommandSourceStack> context) {
        return RuntimeResourceDumpingCommand.execute(context, RuntimeResourceDumpingCommand::write);
    }

    private static int execute(CommandContext<CommandSourceStack> context, Consumer<VisitResult> executor) {
        Arrays.stream(PackType.values()).map(ContentTweakerCore.core().resourceManager()::fragments).map(Map::values).flatMap(Collection::stream).map(RuntimeResourceDumpingCommand::gatherFragment).flatMap(Collection::stream).forEach(executor);
        CommandUtilities.send((Component)CommandUtilities.openingLogFile((MutableComponent)new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent(ContentTweakerConstants.ln("command.dump_resources.log"))), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (CommandSourceStack)((CommandSourceStack)context.getSource()));
        return 1;
    }

    private static List<VisitResult> gatherFragment(RuntimeFragment fragment) {
        ResourceFragment.Key key = fragment.key();
        ArrayList<VisitResult> outer = new ArrayList<VisitResult>();
        fragment.fs().getRootDirectories().forEach(root -> RuntimeResourceDumpingCommand.gatherFromRoot(root, outer, key));
        return outer;
    }

    private static void gatherFromRoot(Path root, List<VisitResult> outer, ResourceFragment.Key key) {
        try {
            Files.walkFileTree(root, new ResourceVisitor(root, key, outer::add));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void write(VisitResult result) {
        try {
            Path dumpPath = DUMP_ROOT.get().resolve(result.name());
            Path parent = dumpPath.getParent();
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.copy(result.path(), dumpPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to correctly dump resource %s due to an error".formatted(result.name()), (Throwable)e);
        }
    }

    private static final class ResourceVisitor
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final ResourceFragment.Key key;
        private final Consumer<Path> pathConsumer;

        ResourceVisitor(Path root, ResourceFragment.Key key, Consumer<VisitResult> resultConsumer) {
            this.root = root;
            this.key = key;
            this.pathConsumer = path -> this.pathToName((Path)path, resultConsumer);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.visitFile(file, attrs);
            if (result != FileVisitResult.CONTINUE) {
                return result;
            }
            if (!attrs.isRegularFile()) {
                return FileVisitResult.CONTINUE;
            }
            DosFileAttributes attributes = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
            if (attributes.isHidden()) {
                return FileVisitResult.CONTINUE;
            }
            this.pathConsumer.accept(file);
            return FileVisitResult.CONTINUE;
        }

        private void pathToName(Path path, Consumer<VisitResult> resultConsumer) {
            Path absolute = path.toAbsolutePath().normalize();
            Path targetPath = this.root.relativize(path.toAbsolutePath().normalize()).normalize();
            resultConsumer.accept(new VisitResult(absolute, "%s/%s/%s".formatted(this.key.type().m_10305_(), this.key.id(), targetPath)));
        }
    }

    private record VisitResult(Path path, String name) {
    }
}

