/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.resource.UserPack;
import com.blamejared.contenttweaker.core.service.ServiceManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.GameVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;

public final class UserRepositorySource
implements RepositorySource {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    private static final Path TARGET = ServiceManager.platform().gameDirectory().resolve("resources");
    private final PackType type;

    private UserRepositorySource(PackType type) {
        this.type = type;
    }

    public static UserRepositorySource of(PackType type) {
        return new UserRepositorySource(Objects.requireNonNull(type));
    }

    public void m_7686_(Consumer<Pack> consumer, Pack.PackConstructor packConstructor) {
        if (this.verify()) {
            return;
        }
        try {
            this.checkUserResources(consumer, packConstructor);
        }
        catch (IOException e) {
            ContentTweakerCore.LOGGER.warn("An error occurred while walking user resources", (Throwable)e);
        }
    }

    private boolean verify() {
        if (!Files.isDirectory(TARGET, new LinkOption[0])) {
            try {
                Files.deleteIfExists(TARGET);
                Files.createDirectory(TARGET, new FileAttribute[0]);
            }
            catch (IOException e) {
                ContentTweakerCore.LOGGER.error("An error occurred while trying to create user directory in " + TARGET + ": user resources won't be available", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    private void checkUserResources(Consumer<Pack> consumer, Pack.PackConstructor constructor) throws IOException {
        consumer.accept(this.pack(constructor));
    }

    private Pack pack(Pack.PackConstructor constructor) throws IOException {
        Path metadataPath = TARGET.resolve("pack.mcmeta");
        JsonObject metadata = this.readMetadata(metadataPath);
        String packId = ContentTweakerConstants.rl("user/" + this.type.name().toLowerCase(Locale.ENGLISH)).toString();
        Pack pack = Pack.m_10430_((String)packId, (boolean)true, () -> this.resources(metadata), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, this::decorateSource);
        if (pack == null) {
            throw new IOException("Unable to create pack due to an unknown IO error", new NullPointerException());
        }
        return pack;
    }

    private JsonObject readMetadata(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ));){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                return jsonObject;
            }
        }
        return this.createMetadata();
    }

    private JsonObject createMetadata() {
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "ContentTweaker User Resources");
        pack.addProperty("pack_format", (Number)this.type.m_143756_((GameVersion)SharedConstants.m_183709_()));
        meta.add("pack", (JsonElement)pack);
        return meta;
    }

    private PackResources resources(JsonObject metadata) {
        FolderPackResources resources = new FolderPackResources(TARGET.toFile());
        return new UserPack(GSON, "User Resources", (PackResources)resources, metadata);
    }

    private Component decorateSource(Component originalName) {
        return new TranslatableComponent("pack.nameAndSource", new Object[]{originalName, new TranslatableComponent(ContentTweakerConstants.ln("pack_source.runtime"))});
    }
}

