/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileAttributes;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileAttributesView;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePath;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePathResolutionResult;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class TrundleAttributes {
    private TrundleAttributes() {
    }

    static boolean hidden(TrundlePathResolutionResult path) throws IOException {
        return path.originalPath().attributes(DosFileAttributes.class, new LinkOption[0]).isHidden();
    }

    static <A extends BasicFileAttributes> A attributes(TrundlePathResolutionResult path, Class<A> type, LinkOption ... options) throws IOException {
        TrundlePath original = path.originalPath();
        if (type == BasicFileAttributes.class) {
            return (A)((BasicFileAttributes)TrundleAttributes.reinterpret(original.fileAttributeView(BasicFileAttributeView.class, options).readAttributes()));
        }
        if (type == DosFileAttributes.class) {
            return (A)((BasicFileAttributes)TrundleAttributes.reinterpret(original.fileAttributeView(DosFileAttributeView.class, options).readAttributes()));
        }
        throw new UnsupportedOperationException("Attributes of type " + type.getName() + " are not supported");
    }

    static Map<String, Object> attributes(TrundlePathResolutionResult path, String attributes, LinkOption ... options) throws IOException {
        boolean isWildcard;
        String view;
        TrundlePath origin = path.originalPath();
        int colon = attributes.indexOf(58);
        String string = view = colon != -1 ? attributes.substring(0, colon) : "basic";
        if (!origin.fileStore().supportsFileAttributeView(view)) {
            throw new UnsupportedOperationException("View " + view + " is not available");
        }
        String[] attributeList = (colon != -1 ? attributes.substring(colon + 1) : attributes).split(Pattern.quote(","));
        int listLength = attributeList.length;
        boolean bl = isWildcard = listLength == 1 && "*".equals(attributeList[0]);
        if (listLength == 0) {
            throw new IllegalArgumentException("At least one attribute must be specified");
        }
        Collection<String> allChosenAttributes = isWildcard ? TrundleFileAttributes.SUPPORTED_ATTRIBUTES : Arrays.asList(attributeList);
        TrundleFileAttributes dos = (TrundleFileAttributes)origin.attributes(DosFileAttributes.class, options);
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        for (String attribute : allChosenAttributes) {
            if (!TrundleFileAttributes.SUPPORTED_ATTRIBUTES.contains(attribute)) {
                throw new IllegalArgumentException();
            }
            Object value = dos.attribute(attribute);
            attributesMap.put(attribute, value);
        }
        return attributesMap;
    }

    static <V extends FileAttributeView> V attributeView(TrundlePathResolutionResult path, Class<V> type, LinkOption ... options) {
        TrundleResource resource = path.element();
        if (resource == null) {
            return null;
        }
        if (type == BasicFileAttributeView.class || type == DosFileAttributeView.class) {
            return (V)((FileAttributeView)TrundleAttributes.reinterpret(TrundleFileAttributesView.of(resource, type)));
        }
        return null;
    }

    static Void attribute(TrundlePathResolutionResult path, String attribute, Object value, LinkOption ... options) throws IOException {
        String targetAttribute;
        String view;
        TrundlePath origin = path.originalPath();
        int colon = attribute.indexOf(58);
        String string = view = colon != -1 ? attribute.substring(0, colon) : "basic";
        if (!origin.fileStore().supportsFileAttributeView(view)) {
            throw new UnsupportedOperationException("View " + view + " is not available");
        }
        String string2 = targetAttribute = colon != -1 ? attribute.substring(colon + 1) : attribute;
        if (!TrundleFileAttributes.SUPPORTED_ATTRIBUTES.contains(targetAttribute)) {
            throw new IllegalArgumentException("Unknown attribute " + targetAttribute);
        }
        TrundleFileAttributes dos = (TrundleFileAttributes)origin.attributes(DosFileAttributes.class, options);
        dos.attribute(targetAttribute, value);
        return null;
    }

    private static <T, U> U reinterpret(T t) {
        return (U)t;
    }
}

