/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFile;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileChannel;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePathResolutionResult;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

final class TrundleChannels {
    private TrundleChannels() {
    }

    static SeekableByteChannel seekableByteChannel(TrundlePathResolutionResult path, Set<? extends OpenOption> openOptions, FileAttribute<?> ... attributes) throws IOException {
        return path.originalPath().fileChannel(openOptions, attributes);
    }

    static FileChannel fileChannel(TrundlePathResolutionResult path, Set<? extends OpenOption> openOptions, FileAttribute<?> ... attributes) throws IOException {
        Flags flags = Flags.of(openOptions);
        TrundleResource file = path.element();
        boolean fileExists = Objects.nonNull(file);
        if (fileExists && flags.failIfPresent()) {
            throw new FileAlreadyExistsException(path.elementName());
        }
        if (!fileExists && flags.failIfAbsent()) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, "No such file: " + path.originalPath());
        }
        if (fileExists && file.type() != TrundleResource.Type.FILE) {
            throw new TrundleException(TrundleException.Code.READ_NOT_SUPPORTED, "Unable to read " + path.originalPath());
        }
        if (!fileExists) {
            TrundleResource parent = path.parent();
            TrundleFile newlyCreatedFile = new TrundleFile(path.elementName(), new ArrayList(Arrays.asList(attributes)));
            parent.add(newlyCreatedFile);
        }
        TrundleResource actualFile = fileExists ? file : path.parent().resolve(path.elementName());
        long position = flags.append() ? actualFile.size() : 0L;
        return new TrundleFileChannel((TrundleFile)actualFile, flags.read(), flags.write(), position);
    }

    static AsynchronousFileChannel asyncFileChannel(TrundlePathResolutionResult path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attributes) throws IOException {
        throw new IOException(new UnsupportedOperationException("Not yet implemented"));
    }

    private record Flags(boolean read, boolean write, boolean append, boolean truncate, boolean failIfPresent) {
        static Flags of(Set<? extends OpenOption> options) {
            boolean read = options.contains(StandardOpenOption.READ) || Flags.shouldDefault(options);
            boolean write = options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND);
            boolean append = options.contains(StandardOpenOption.APPEND);
            boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
            boolean failIfPresent = options.contains(StandardOpenOption.CREATE_NEW);
            Flags flags = new Flags(read, write, append, truncate, failIfPresent);
            flags.validate(options);
            return flags;
        }

        private static boolean shouldDefault(Set<? extends OpenOption> options) {
            return !options.contains(StandardOpenOption.READ) && !options.contains(StandardOpenOption.WRITE) && !options.contains(StandardOpenOption.APPEND);
        }

        boolean failIfAbsent() {
            return this.read && !this.write && !this.append;
        }

        private void validate(Set<? extends OpenOption> options) {
            if (this.append() && (this.read() || this.truncate())) {
                throw new IllegalArgumentException("Illegal combination of attributes");
            }
            if (options.contains(StandardOpenOption.DSYNC) || options.contains(StandardOpenOption.SYNC)) {
                throw new UnsupportedOperationException("Unsupported synchronous I/O");
            }
        }
    }
}

