/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class TrundleDirectory
extends TrundleResource {
    private final Map<String, TrundleResource> children = new LinkedHashMap<String, TrundleResource>();

    TrundleDirectory(String name, List<FileAttribute<?>> attributes) {
        super(name, TrundleResource.Type.DIRECTORY, attributes);
    }

    @Override
    void add(TrundleResource resource) {
        Objects.requireNonNull(resource);
        String name = resource.name();
        if (this.children.containsKey(name)) {
            throw new TrundleException(TrundleException.Code.ITEM_ALREADY_EXISTS, name);
        }
        this.children.put(name, resource);
    }

    @Override
    void remove(TrundleResource resource) {
        Objects.requireNonNull(resource);
        String name = resource.name();
        if (!this.children.containsKey(name)) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, name);
        }
        if (!this.children.remove(name, resource)) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, name);
        }
    }

    @Override
    TrundleResource tryResolve(String name) {
        Objects.requireNonNull(name);
        return this.children.get(name);
    }

    @Override
    byte[] contents() {
        throw new TrundleException(TrundleException.Code.READ_NOT_SUPPORTED, this.name() + " is not a file");
    }

    @Override
    long size() {
        throw new TrundleException(TrundleException.Code.READ_NOT_SUPPORTED, this.name() + " is not a file");
    }

    Map<String, TrundleResource> children() {
        return this.children;
    }
}

