/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.io.IOException;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

final class TrundleFileAttributes
implements DosFileAttributes {
    static final String HIDDEN = "h";
    static final String READ_ONLY = "r";
    static final Set<String> SUPPORTED_ATTRIBUTES = Set.of("h");
    private static final Map<String, Function<String, ? extends ModifiableFileAttribute<?>>> ATTRIBUTE_CREATORS = Map.of("h", BooleanAttribute::new);
    private final TrundleResource resource;
    private final Map<String, FileAttribute<?>> attributes;

    private TrundleFileAttributes(TrundleResource resource, Map<String, FileAttribute<?>> attributes) {
        this.resource = resource;
        this.attributes = attributes;
    }

    static TrundleFileAttributes of(TrundleResource resource) throws IOException {
        if (resource == null) {
            throw new IOException("Unable to read resource");
        }
        return resource.attributesObject();
    }

    static TrundleFileAttributes of(TrundleResource resource, Map<String, FileAttribute<?>> attributes) {
        return new TrundleFileAttributes(Objects.requireNonNull(resource), Objects.requireNonNull(attributes));
    }

    static Map<String, FileAttribute<?>> bake(Map<String, FileAttribute<?>> original) {
        LinkedHashMap baked = new LinkedHashMap(original);
        for (String attribute : SUPPORTED_ATTRIBUTES) {
            baked.computeIfAbsent(attribute, it -> ATTRIBUTE_CREATORS.get(it).apply((String)it));
        }
        return baked;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.booleanAttribute(HIDDEN).value();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public FileTime lastModifiedTime() {
        return null;
    }

    @Override
    public FileTime lastAccessTime() {
        return null;
    }

    @Override
    public FileTime creationTime() {
        return null;
    }

    @Override
    public boolean isRegularFile() {
        return this.resource.type() == TrundleResource.Type.FILE;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.type() == TrundleResource.Type.DIRECTORY;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.isRegularFile() ? this.resource.size() : 0L;
    }

    @Override
    public Object fileKey() {
        return null;
    }

    void setHidden(boolean value) {
        this.booleanAttribute(HIDDEN).value(value);
    }

    void setReadOnly(boolean value) {
    }

    void setSystem(boolean value) {
    }

    void setArchive(boolean value) {
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
    }

    Object attribute(String attribute) {
        Objects.requireNonNull(attribute);
        return this.attributes.get(attribute).value();
    }

    <T> void attribute(String attribute, T value) {
        Objects.requireNonNull(attribute);
        Objects.requireNonNull(value);
        FileAttribute<?> fileAttribute = this.attributes.get(attribute);
        if (!(fileAttribute instanceof ModifiableFileAttribute)) {
            throw new IllegalStateException();
        }
        ModifiableFileAttribute modifiableFileAttribute = (ModifiableFileAttribute)fileAttribute;
        modifiableFileAttribute.value(value);
    }

    private BooleanAttribute booleanAttribute(String name) {
        FileAttribute attribute = this.attributes.computeIfAbsent(name, BooleanAttribute::new);
        if (!(attribute instanceof BooleanAttribute)) {
            throw new IllegalStateException();
        }
        BooleanAttribute booleanAttribute = (BooleanAttribute)attribute;
        return booleanAttribute;
    }

    private static final class BooleanAttribute
    implements ModifiableFileAttribute<Boolean> {
        private final String name;
        private boolean value;

        BooleanAttribute(String name) {
            this(name, false);
        }

        BooleanAttribute(String name, boolean initialValue) {
            this.name = Objects.requireNonNull(name);
            this.value = initialValue;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        @Override
        public void value(Boolean value) {
            this.value = value;
        }
    }

    private static interface ModifiableFileAttribute<T>
    extends FileAttribute<T> {
        public void value(T var1);
    }
}

