/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleAttributes;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleChannels;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleDirectory;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleDirectoryStream;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileSystemProvider;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleMemoryFileStore;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePath;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePathResolutionResult;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

final class TrundleFileSystem
extends FileSystem {
    private final TrundleFileSystemProvider provider;
    private final String name;
    private volatile TrundleMemoryFileStore fileStore;
    private volatile TrundleDirectory root;
    private volatile boolean closed;

    private TrundleFileSystem(TrundleFileSystemProvider provider, String name, String rootName) {
        this.provider = Objects.requireNonNull(provider);
        this.name = Objects.requireNonNull(name);
        this.fileStore = new TrundleMemoryFileStore("memory@" + name);
        this.root = new TrundleDirectory(Objects.requireNonNull(rootName), new ArrayList());
        this.closed = false;
    }

    static TrundleFileSystem of(TrundleFileSystemProvider provider, String name, Map<String, ?> environment) {
        Objects.requireNonNull(provider);
        Objects.requireNonNull(name);
        Objects.requireNonNull(environment);
        String rootName = Optional.ofNullable(environment.get("rootName")).map(String.class::cast).orElse("");
        return new TrundleFileSystem(provider, name, rootName);
    }

    String name() {
        return this.name;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        TrundleFileSystem trundleFileSystem = this;
        synchronized (trundleFileSystem) {
            if (this.closed) {
                return;
            }
            this.root = null;
            this.fileStore = null;
            this.closed = true;
            this.provider.removeFileSystem(this.name);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return Collections.singleton(TrundlePath.of(this, "/"));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return Collections.singletonList(this.fileStore);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return Collections.singleton("basic");
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(more);
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        StringBuilder path = new StringBuilder(first);
        for (String additional : more) {
            if (additional.isEmpty()) continue;
            path.append(this.getSeparator()).append(additional);
        }
        return TrundlePath.of(this, path.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        Objects.requireNonNull(syntaxAndPattern);
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("A Trundle file system does not have a user principal lookup service");
    }

    @Override
    public WatchService newWatchService() {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    SeekableByteChannel seekableByteChannel(TrundlePath path, Set<? extends OpenOption> options, FileAttribute<?> ... attributes) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleChannels.seekableByteChannel(this.resolve(path), options, attributes));
    }

    DirectoryStream<Path> directoryStream(TrundlePath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleDirectoryStream.of(this, this.resolve(path), filter));
    }

    void createDirectory(TrundlePath path, FileAttribute<?> ... attrs) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleResources.directory(this.resolve(path), attrs));
    }

    void delete(TrundlePath path) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleResources.delete(this.resolve(path)));
    }

    void copy(TrundlePath from, TrundlePath to, CopyOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleResources.copy(this.resolve(from), this.resolve(to), options));
    }

    void move(TrundlePath from, TrundlePath to, CopyOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleResources.move(this.resolve(from), this.resolve(to), options));
    }

    boolean isSameFile(TrundlePath a, TrundlePath b) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleResources.same(this.resolve(a), this.resolve(b)));
    }

    boolean isHidden(TrundlePath path) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleResources.hidden(this.resolve(path)));
    }

    FileStore fileStore(TrundlePath path) {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.fileStore;
    }

    void checkAccess(TrundlePath path, AccessMode ... modes) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleResources.access(this.resolveOrNoSuchFile(path), modes));
    }

    <V extends FileAttributeView> V fileAttributeView(TrundlePath path, Class<V> type, LinkOption ... options) {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return TrundleAttributes.attributeView(this.resolve(path), type, options);
    }

    <A extends BasicFileAttributes> A attributes(TrundlePath path, Class<A> type, LinkOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return (A)this.catching(() -> TrundleAttributes.attributes(this.resolve(path), type, options));
    }

    Map<String, Object> attributes(TrundlePath path, String attributes, LinkOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleAttributes.attributes(this.resolve(path), attributes, options));
    }

    void attribute(TrundlePath path, String attribute, Object value, LinkOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.catching(() -> TrundleAttributes.attribute(this.resolve(path), attribute, value, options));
    }

    InputStream inputStream(TrundlePath path, OpenOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return Channels.newInputStream(path.seekableByteChannel(Set.of(options), new FileAttribute[0]));
    }

    OutputStream outputStream(TrundlePath path, OpenOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return Channels.newOutputStream(path.seekableByteChannel(Set.of(options), new FileAttribute[0]));
    }

    FileChannel fileChannel(TrundlePath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleChannels.fileChannel(this.resolve(path), options, attrs));
    }

    AsynchronousFileChannel asyncFileChannel(TrundlePath path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleChannels.asyncFileChannel(this.resolve(path), options, executor, attrs));
    }

    boolean deleteIfExist(TrundlePath path) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return this.catching(() -> TrundleResources.deleteIfExists(this.resolve(path)));
    }

    private TrundlePathResolutionResult resolveOrNoSuchFile(TrundlePath path) throws IOException {
        try {
            return this.resolve(path);
        }
        catch (TrundleException e) {
            if (e.code() != TrundleException.Code.RESOLUTION_ERROR) {
                throw e;
            }
            String[] portions = path.pathPortions();
            int last = portions.length - 1;
            String name = portions[last];
            NoSuchFileException noFileException = new NoSuchFileException(name);
            noFileException.initCause(e);
            throw noFileException;
        }
    }

    private TrundlePathResolutionResult resolve(TrundlePath path) {
        try {
            if (path.getParent() == null) {
                return new TrundlePathResolutionResult(path, null, "/", this.root);
            }
            String[] portions = path.pathPortions();
            int last = portions.length - 1;
            String name = portions[last];
            TrundleResource resource = this.root;
            for (int i = 0; i < last; ++i) {
                resource = resource.resolve(portions[i]);
            }
            return new TrundlePathResolutionResult(path, resource, name, resource.tryResolve(name));
        }
        catch (Exception e) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, "Unable to resolve path '" + path + "' within the file system", e);
        }
    }

    private <T> T catching(ExceptionalRunnable<T> runnable) throws IOException {
        try {
            return runnable.run();
        }
        catch (TrundleException e) {
            throw e.asIoException();
        }
        catch (NullPointerException e) {
            throw new IOException("A critical error has been encountered while handling the file system", e);
        }
    }

    @FunctionalInterface
    private static interface ExceptionalRunnable<T> {
        public T run() throws IOException;
    }
}

